/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.excel;

import com.baijia.tianxiao.excel.ExcelCell;
import com.baijia.tianxiao.excel.ExcelType;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class ExcelHandler {
    private Map<String, ExcelType> handler = new HashMap<String, ExcelType>();
    private Map<String, String> dataFormats = Maps.newHashMap();

    public void registerTimeFormat(String fieldName, String format) {
        this.dataFormats.put(fieldName, format);
    }

    public void registerHandler(String fieldName, ExcelType excleType) {
        this.handler.put(fieldName, excleType);
    }

    public void batchRegisterHandler(String[] fieldName, ExcelType excelType) {
        if (excelType == null) {
            return;
        }
        for (String str : fieldName) {
            if (this.handler.containsKey(str)) continue;
            this.handler.put(str, excelType);
        }
    }

    public ExcelCell getExcelValue(String fieldName, Object value) {
        ExcelType excelType = this.handler.get(fieldName);
        if (excelType == null) {
            return null;
        }
        return excelType.getExcelCell(value, this.dataFormats.get(fieldName));
    }

    public void clear() {
        this.handler.clear();
    }
}

