/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;
import com.baijia.tianxiao.util.ErrorCodeUtil;

public enum CommonErrorCode implements UniverseErrorCode
{
    UNKNOW(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 1, "\u672a\u77e5\u7c7b\u578b\u9519\u8bef"),
    PARAM_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 400, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5"),
    REQUIRE_PARAM(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 401, "\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570"),
    SIGN_INVALIDATE(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 402, "\u53c2\u6570\u68c0\u9a8c\u4e0d\u901a\u8fc7"),
    INVALIDATE_CLIENTID(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 403, "clientId\u4e0d\u5408\u6cd5"),
    TOKEN_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 408, "TOKEN\u4e0d\u5408\u6cd5"),
    NO_LOGIN(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 500, "\u901a\u7528\u7248\u7528\u6237\u672a\u767b\u5f55"),
    NO_LOGIN_ONLINE_ORG(ErrorSide.SERVER, Subsystem.WANGXIAO, Platform.PC, 501, "\u7f51\u6821\u7248\u7528\u6237\u672a\u767b\u5f55"),
    NO_LOGIN_STUDENT_CENTER(ErrorSide.SERVER, Subsystem.STUDENT_CENTER, Platform.M, 502, "\u5b66\u751f\u4e2a\u4eba\u4e2d\u5fc3\u672a\u767b\u5f55"),
    NO_LOGIN_TEACHER_CENTER(ErrorSide.SERVER, Subsystem.TEACHER_CENTER, Platform.M, 503, "\u8001\u5e08\u4e2a\u4eba\u4e2d\u5fc3\u672a\u767b\u5f55"),
    REQUEST_EXCEED(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 300, "\u8d85\u51fa\u8bf7\u6c42\u6b21\u6570\u9650\u5236"),
    NOT_FOUND(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 404, "\u6240\u8bf7\u6c42\u8d44\u6e90\u4e0d\u5b58\u5728"),
    IO_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 600, "\u540e\u53f0\u5904\u7406IO\u5f02\u5e38"),
    PERMISSION_DENY(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 700, "\u65e0\u8bf7\u6c42\u8be5\u8d44\u6e90\u6743\u9650"),
    PERMISSION_DENY_AND_JUMP(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.PC, 701, "\u603b\u6821\u8d44\u6e90,\u5206\u6821\u65e0\u6743\u9650\u8bbf\u95ee"),
    PERMISSION_DENY_AND_JUMP_WANGXIAO(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.PC, 702, "\u603b\u6821\u8d44\u6e90,\u7f51\u6821\u65e0\u6743\u9650\u8bbf\u95ee"),
    BUSINESS_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 800, "\u4e1a\u52a1\u5904\u7406\u5f02\u5e38"),
    NEED_RE_LOGIN(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 900, "\u6743\u9650\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55"),
    SYSTEM_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 9999, "\u7cfb\u7edf\u5904\u7406\u5f02\u5e38");

    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private CommonErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }

    @Override
    public ErrorSide getErrorSide() {
        return this.errorSide;
    }

    @Override
    public Subsystem getSystem() {
        return this.subsystem;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public CommonErrorCode fromCode(int code) {
        for (CommonErrorCode errorCode : CommonErrorCode.values()) {
            if (errorCode.getSubsystemErrorCode() != code) continue;
            return errorCode;
        }
        return UNKNOW;
    }

    public static void main(String[] args) {
        System.out.println(ErrorCodeUtil.getUniverseErrorCode(NO_LOGIN_STUDENT_CENTER));
    }
}

