package com.baijia.tianxiao.util.excel;

import com.baijia.tianxiao.annotation.AnchorContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections4.CollectionUtils;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 
 * @author zhangbing
 *
 * @param <T>
 */
public class ExportUtils<T> {

	/**
	 * 根据annotation得出excel header并排序以及T对象中需要导出的属性集合以及集合属性导出顺序
	 * @param clazz
	 * @return
	 */
	public static <T> Map<String, List<String>> generateHeader(Class<T> clazz) {
		Map<String, List<String>> result = Maps.newHashMap();
		List<String> headers = Lists.newArrayList();
		List<String> fieldNames = Lists.newArrayList();

		List<Field> fields = Lists.newArrayList();
		Class<?> superClass = clazz;
		
		while (superClass != null) {
			fields.addAll(Arrays.asList(Arrays.copyOf(superClass.getDeclaredFields(), superClass.getDeclaredFields().length)));
			superClass = superClass.getSuperclass();
		}

		if (CollectionUtils.isNotEmpty(fields)) {
			fields = fields.stream().filter(f -> f.getAnnotation(AnchorContext.class) != null).sorted(new Comparator<Field>() {

				@Override
				public int compare(Field o1, Field o2) {
					return o1.getAnnotation(AnchorContext.class).position() - o2.getAnnotation(AnchorContext.class).position();
				}
			}).collect(Collectors.toList());
		}
		for (Field field : fields) {
			AnchorContext context = field.getAnnotation(AnchorContext.class);
			fieldNames.add(field.getName());
			headers.add(context.header());
		}
		result.put("headers", headers);
		result.put("fieldNames", fieldNames);
		return result;
	}
}
