package com.baijia.tianxiao.util.date;

import org.apache.commons.lang3.StringUtils;

import java.beans.PropertyEditorSupport;
import java.util.Date;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 15/7/17.
 */
@Slf4j
public class TimeStampPropertyEditor extends PropertyEditorSupport {

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty(text)) {
            setValue(null);
        } else {
            try {
                long time = Long.parseLong(text);
                if (time <= 0) {
                    setValue(null);
                }
                Date date = new Date(time);
                setValue(date);
            } catch (Exception e) {
                log.error("Exception e={}", e);
                setValue(null);
            }
        }
    }

    @Override
    public String getAsText() {
        Date value = (Date) getValue();
        if (value == null) {
            return "";
        } else {
            try {
                return String.valueOf(value.getTime());
            } catch (Exception e) {
                log.error("Exception e={}", e);
                return "";
            }
        }
    }
}
