
package com.baijia.tianxiao.filter;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @title AbstractTXWebContext
 * @desc TODO 
 * @author caoliang
 * @date 2016年3月16日
 * @version 1.0
 */
    
public abstract class AbstractTXWebContext {
    
    protected static final ThreadLocal<Map<String, Object>> cache = ThreadLocal.withInitial(() -> Maps.newHashMap());
    
    protected abstract void init();
    
    protected static <T> void set(String key, T value){
        cache.get().put(key, value);
    }
    
    protected static Object get(String key){
        return cache.get().get(key);
    }
    
    @SuppressWarnings("unchecked")
    protected static <T> T get(String key, Class<T> clazz){
        return (T) cache.get().get(key);
    }
    
    public static void clear(){
        cache.remove();
    }
}
