package com.baijia.tianxiao.excel;

import java.sql.Timestamp;
import java.util.Date;

import com.baijia.tianxiao.util.GenericsUtils;

public enum ExcelType {

    GENERAL() {
        @Override
        public ExcelCell getExcelCell(Object value, String...dataFormat) {
            return new ExcelCell(value);
        }
    },
    DATE() {
        @Override
        public ExcelCell getExcelCell(Object value, String...dataFormat) {
            String format = FORMAT_DATA;
            if (GenericsUtils.isNullOrEmpty(dataFormat)) {
                format = dataFormat[0];
            }
            if (value instanceof Long) {
                return ExcelUtils.createExcelDate(new Date((Long) value), format);
            } else if (value instanceof Date) {
                return ExcelUtils.createExcelDate((Date) value, format);
            } else if (value instanceof Timestamp) {
                return ExcelUtils.createExcelDate((Timestamp) value, format);
            }
            return null;
        }
    },
    INTEGER() {
        @Override
        public ExcelCell getExcelCell(Object value, String...dataFormat) {
            return ExcelUtils.createExcelInteger((Integer) value);
        }
    },
    MONEY() {
        @Override
        public ExcelCell getExcelCell(Object value, String...dataFormat) {
            return ExcelUtils.createExcelMoney((Double) value);
        }
    };

    public static final String FORMAT_DATA = "yyyy-MM-dd HH:mm:ss";

    public abstract ExcelCell getExcelCell(Object value, String...dataFormat);
}
