
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dto.query;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.annotation.Option;
import com.baijia.tianxiao.annotation.Snippet;
import com.baijia.tianxiao.enums.SortPolicy;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import lombok.Data;

/**
 * @author zhangbing
 * @version 1.0
 * @title ConsultSearchRequestDto
 * @desc TODO
 * @date 2016年3月14日
 */
@Data
public class CommonSearchRequestDto {

    // 排序规则,默认升序0:升序,1:降序
    private Integer orderType = 0;

    // 属性名称
    private String name;

    // 排序字段
    private String orderName;

    // 查询value
    private String query;

    // 起始时间
    private Long start;

    // 结束时间
    private Long end;

    // 页码
    private Integer pageNum;

    // 分页size
    private Integer pageSize = 20;

    private Integer status;// 列表筛选状态

    private Integer consultStatus;//跟进状态,参考ConsultUserStatus

    private Integer intensionLevel;//意向级别

    private Integer source;//来源

    private String dateFieldKey;//日期类型的筛选

    // 数据传输对象
    private Integer cascadeId;
    private Integer birthMonth;
    private Integer birthYear;
    private Integer birthDayOfMonth;

    private String selectFieldKey;
    private Integer selectFieldValue;

    private Integer scheduleStatus;//是否排课
    private Integer refundClassStatus;//是否退班
    private Integer stuCenterBindStatus;//是否绑定个人中心
    private Long classId;//所在班级

    private Integer lessonStatType;
    private Integer maxNum;
    private Integer minNum;


    public PageDto getPageDto() {
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(pageNum);
        pageDto.setPageSize(pageSize);
        return pageDto;
    }

    /**
     * 封装查询:排序、分页、模糊/精准
     *
     * @param clazz
     * @return
     */
    public AutoMatchQueryRequest generateAutoMatchModel(Class<?> clazz) {
        AutoMatchQueryRequest model = new AutoMatchQueryRequest();
        if (StringUtils.isBlank(name) && StringUtils.isBlank(query) && StringUtils.isBlank(orderName)) {
            return null;
        }
        if (StringUtils.isNotBlank(orderName)) {
            model.setSortPolicy(this.orderType == 0 ? SortPolicy.ASC : SortPolicy.DESC);
            model.setOrderName(this.orderName);
        }
        if (StringUtils.isNotBlank(name) && !name.equals("tag")) {
            Option option = Snippet.getAnnotation(clazz, this.name);
            if (option != null) {
                model.setQueryPolicy(option.policy());
                model.setPropName(option.name());
            }

            if (StringUtils.isBlank(query)) {
                return model;
            }
            switch (option.type()) {
                case STRING:
                    model.setValue(query);
                    break;
                case DIGITAL:
                    model.setValue(query);
                    break;
                case DATE:
                    model.setStart(new Date(this.start));
                    model.setEnd(new Date(this.end));
                    break;
                default:
                    break;
            }
        }
        return model;
    }
}
