package com.baijia.tianxiao.constants;

import java.util.Map;
import java.util.Set;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

public enum MIMEType {

    JPG(1, "image/jpg", "jpg"),

    JPEG(2, "image/jpeg", "jpeg"),

    PNG(3, "image/png", "png"),

    MP3(4, "audio/mp3", "mp3"),

    AMR(5, "audio/amr", "amr"),

    SVG(6, "image/svg", "svg"),

    AAC(7, "audio/aac", "aac"),
    
    ICON(8, "audio/ico", "ico"),
    
    MP4(9, "video/mp4", "mp4"),

    ;
    public static Set<String> imgExtension = Sets.newHashSet();

    private static Map<String, MIMEType> extensionToTypeMap = Maps.newHashMap();
    private static Map<String, Integer> extensionToCodeMap = Maps.newHashMap();
    private static Map<Integer, String> codeToExtensionMap = Maps.newHashMap();
    private static Map<Integer, MIMEType> typeToExtensionMap = Maps.newHashMap();

    static {
        for (MIMEType type : MIMEType.values()) {
            extensionToTypeMap.put(type.getExtension(), type);
            extensionToCodeMap.put(type.getExtension(), type.code);
            codeToExtensionMap.put(type.getCode(), type.getExtension());
            typeToExtensionMap.put(type.getCode(), type);

            if (type.type.startsWith("image/")) {
                imgExtension.add(type.extension);
            }
        }
    }

    private int code;
    private String type;
    private String extension;

    private MIMEType(int code, String type, String extension) {
        this.code = code;
        this.type = type;
        this.extension = extension;
    }

    public int getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getExtension() {
        return this.extension;
    }

    public static MIMEType getType(String extension) {
        return extensionToTypeMap.get(extension);
    }

    public static Integer getCode(String extension) {
        return extensionToCodeMap.get(extension);
    }

    public static String getExtension(Integer code) {
        return codeToExtensionMap.get(code);
    }

    public static MIMEType getMimeType(Integer code) {
        return typeToExtensionMap.get(code);
    }

}
