
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.validation;

import java.util.Map;

import com.baijia.tianxiao.dto.mobile.AppAuthToken;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @title ValidateTokenUtil
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年10月9日
 * @version 1.0
 */
@Slf4j
public class ValidateTokenUtil {
    
    public static Map<String, Integer> accountVersionMap = Maps.newConcurrentMap();
    public static final String CASCADE_PREFIX = "cascade_prefix_";
    public static final String ORG_ID_PREFIX = "orgid_prefix_";

    public static final boolean isTokenValid(AppAuthToken token) {
        boolean result = true;
        Integer txCascadeUserId = token.getTx_cascade_user_id();
        Integer orgId = token.getUser_id().intValue();
        Integer tokenVersion = token.getAccountVersion();
        log.debug("InnerSync token:{}",token);
        if (txCascadeUserId != null) {
            if (accountVersionMap.containsKey(CASCADE_PREFIX+txCascadeUserId)) {
                Integer dbVersion = accountVersionMap.get(CASCADE_PREFIX+txCascadeUserId);
                if(tokenVersion == null){
                    if(dbVersion > 0){
                        return false;
                    }
                }else{
                    if(dbVersion.intValue() > tokenVersion){
                        return false;
                    }
                }
            }
        } else if (orgId != null) {
            if (accountVersionMap.containsKey(ORG_ID_PREFIX+orgId)) {
                Integer dbVersion = accountVersionMap.get(ORG_ID_PREFIX+orgId);
                if(tokenVersion == null){
                    if(dbVersion > 0){
                        return false;
                    }
                }else{
                    if(dbVersion.intValue() > tokenVersion){
                        return false;
                    }
                }
            }
        }
        return result;
    }

}
