package com.baijia.tianxiao.util.http;

/**
 * Created by wengshengli on 15/12/13.
 */

import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.util.json.JacksonUtil;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.formula.functions.T;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebCommonsUtils {

    public static void returnWebResponse(HttpServletResponse response, WebResponse<T> webResponse) {
        returnMessage(response, JacksonUtil.obj2Str(webResponse));
    }

    public static void returnMessage(HttpServletResponse response, String content) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        PrintWriter pWriter = null;
        try {
            pWriter = response.getWriter();
            pWriter.write(content);
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            if (pWriter != null) {
                pWriter.flush();
                pWriter.close();
            }
        }
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("x-requested-with");
        if (org.apache.commons.lang3.StringUtils.isEmpty(requestedWith)) {
            return false;
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty(requestedWith)
            && requestedWith.equals("XMLHttpRequest")) {
            return true;
        }
        return false;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("http_client_ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip != null) {
            int index = ip.indexOf(",");
            if (index != -1) {
                ip = ip.substring(0, index).trim();
            }
        }
        return ip;
    }

    public static String getAllIpAddr(HttpServletRequest request) {
        StringBuilder allIp = new StringBuilder();
        String name = "x-forwarded-for";
        String ip = request.getHeader(name);
        if (StringUtils.isNotBlank(ip) && "unknown".equalsIgnoreCase(ip) == false) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        name = "Proxy-Client-IP";
        ip = request.getHeader(name);
        if (StringUtils.isNotBlank(ip) && "unknown".equalsIgnoreCase(ip) == false) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        name = "WL-Proxy-Client-IP";
        ip = request.getHeader(name);
        if (StringUtils.isNotBlank(ip) && "unknown".equalsIgnoreCase(ip) == false) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        name = "getRemoteAddr";
        ip = request.getRemoteAddr();
        if (StringUtils.isNotBlank(ip) && "unknown".equalsIgnoreCase(ip) == false) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        name = "http_client_ip";
        ip = request.getHeader(name);
        if (StringUtils.isNotBlank(ip) && "unknown".equalsIgnoreCase(ip) == false) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        name = "HTTP_X_FORWARDED_FOR";
        ip = request.getHeader(name);
        if (StringUtils.isNotBlank(ip) && "unknown".equalsIgnoreCase(ip) == false) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        return allIp.toString();
    }

    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        Map<String, String> params = new HashMap<String, String>();
        for (String key : (Set<String>) request.getParameterMap().keySet()) {
            if (key.toLowerCase().indexOf("password") > -1) {
                params.put(key, "************");
            } else {
                params.put(key, StringUtils.join(request.getParameterValues(key), ","));
            }
        }
        return params;
    }
}
