package com.baijia.tianxiao.util.bean;

import org.apache.commons.beanutils.PropertyUtilsBean;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by liuxp on 16/1/15.
 */
public class ObjectUtil {

    /**
     * 拷贝非空属性
     * @param source
     * @param target
     */
    public static void copyNotNullProperties(Object source,Object target){
        BeanUtils.copyProperties(source,target,getNotNullProperties(source));
    }

    public static String[] getNotNullProperties(Object obj){
        final BeanWrapper src = new BeanWrapperImpl(obj);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();

        Set<String> emptyNames = new HashSet<String>();
        for(PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue == null) emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }
    
}
