
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.util;

import java.text.SimpleDateFormat;
import java.util.Date;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;

import com.baijia.tianxiao.util.date.DateUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time May 18, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public class SmsContentHelper {

    private static final int MAX_COURSE_NAME_LENGTH = 11;
    private static final int MAX_ORG_NAME_LENGTH = 9;
    private static final int MAX_TEACHER_NAME_LENGTH = 6;
    public static String defaultServerPhone = "4000910910";
    public static String defaultDownUrl = "http://tianxiao100.com/download.do";
    public static String DEFAULT_SMS_SIGN_CONTENT = "天校";

    /**
     * 短信字数=短信内容字数+签名字数【天校】
     * 如果短信字数<=70个字数，按照70个一条计算
     * 如果短信字数>70,即为长短信按照
     *
     * @return
     */
    public static int countChargeSmsNum(String content, String signName) {
        if (StringUtils.isEmpty(content) || StringUtils.isEmpty(signName)) {
            return 1;
        }
        StringBuilder sb = new StringBuilder(content).append("【").append(signName).append("】");
        if (sb.toString().length() <= 70) {
            return 1;
        } else {
            System.out.println(sb.toString().length());
            System.out.println(sb.toString().length() / 67);
            if (sb.toString().length() % 67 == 0) {
                return sb.toString().length() / 67;
            } else {
                return sb.toString().length() / 67 + 1;
            }
        }
    }

    /**
     * M站报名支付验证码
     *
     * @param verifyCode
     * @return
     */
    public static String createMPaySmsCodeSmsMsg(String verifyCode, int timeStep) {
        return String.format(TxSmsCodeType.M_PAY_SMS_CODE.getMsg(), verifyCode, timeStep);
    }

    /**
     * 创建远程支付
     *
     * @param courseName
     * @param orgName
     * @param courseNum
     * @return
     */
    public static String createSignupPaySmsMsg(String courseName, String orgName, String url, int courseNum) {
        courseName = replaceSpecialSign(courseName);
        orgName = replaceSpecialSign(orgName);
        courseName = solveLength(courseName, MAX_COURSE_NAME_LENGTH);
        orgName = solveLength(orgName, MAX_ORG_NAME_LENGTH);
        if (courseNum > 1) {
            return String.format(TxSmsCodeType.SIGNUP_PAY_SMS_CONTENT_MANY_TEMPLATE.getMsg(), courseName, courseNum,
                    url, orgName);
        } else {
            return String.format(TxSmsCodeType.SIGNUP_PAY_SMS_CONTENT_SIGNAL_TEMPLATE.getMsg(), courseName, url,
                    orgName);
        }
    }

    /**
     * >>>>>>> s_2_25
     * 创建 申请找回密码短信
     *
     * @param code
     * @param timeStep
     * @return
     */
    public static String createForgetPwdSmsMsg(String code, int timeStep) {
        return String.format(TxSmsCodeType.FORGOTPWD_VALID_CODE_CONTENT.getMsg(), code, timeStep, defaultServerPhone);
    }

    /**
     * 创建 申请试用天校
     *
     * @param code
     * @param timeStep
     * @return
     */
    public static String createApplyTXSmsMsg(String code, int timeStep) {
        return String.format(TxSmsCodeType.APPLY.getMsg(), code, timeStep, defaultServerPhone);
    }

    /**
     * 创建 设置支付密码
     *
     * @param code
     * @param timeStep
     * @return
     */
    public static String createSavePayPwdSmsMsg(String code, int timeStep) {
        return String.format(TxSmsCodeType.SAVE_PAY_PWD.getMsg(), code, timeStep, defaultServerPhone);
    }

    /**
     * 创建 体验账号开通
     *
     * @param userName
     * @param pwd
     * @param defaultVisitorDay
     * @return
     */
    public static String createTryExpTianxiaoTemplateSmsMsg(String userName, String pwd, int defaultVisitorDay) {
        userName = replaceSpecialSign(userName);
        return String.format(TxSmsCodeType.TRY_OPEN_TEMPLATE.getMsg(), userName, pwd, defaultVisitorDay,
                getAppDownload());
    }

    /**
     * 大众版开通
     *
     * @return
     */
    public static String createDaZhongBanKaiTongSmsMsg() {
        return String.format(TxSmsCodeType.OPEN_DAZHONGBAN.getMsg(), defaultServerPhone);
    }

    /**
     * 体验账号过期提醒
     *
     * @return
     */
    public static String createVisitorAccountExpireNotifySmsMsg() {
        return String.format(TxSmsCodeType.ONE_DAY_REMAIND_TEMPLATE.getMsg(), getAppDownload());
    }

    /**
     * 体验账号过期
     *
     * @return
     */
    public static String createVisitorAccountExpired() {
        return String.format(TxSmsCodeType.HAS_RELEASE_TEMPLATE.getMsg(), defaultServerPhone);
    }

    /**
     * 创建浅注册密码
     *
     * @param mobile
     * @param pwd
     * @return
     */
    public static String createNewOrgPwdSmsContent(String mobile, String pwd) {
        String content =
                String.format(TxSmsCodeType.NEW_ORG_PWD.getMsg(), mobile, pwd, SmsContentHelper.getAppDownload());
        return content;
    }

    /**
     * 创建 邀请子账号
     *
     * @param mobile
     * @param pwd
     * @return
     */
    public static String createNewNewCascadePwdSmsMsg(String mobile, String pwd) {
        String content =
                String.format(TxSmsCodeType.NEW_CASCADE_PWD.getMsg(), mobile, pwd, SmsContentHelper.getAppDownload());
        return content;
    }

    /**
     * 创建添加分校验证码
     * <p>
     * 机构名使用完整格式
     *
     * @param code
     * @param mainOrgName
     * @param subOrgName
     * @return
     */
    public static String createInviteToBeCampus(String code, String mainOrgName, String subOrgName) {
        // mainOrgName = solveLength(mainOrgName, MAX_ORG_NAME_LENGTH);
        // subOrgName = solveLength(subOrgName, MAX_ORG_NAME_LENGTH);
        mainOrgName = replaceSpecialSign(mainOrgName);
        subOrgName = replaceSpecialSign(subOrgName);
        String content =
                String.format(TxSmsCodeType.INVITE_TOBE_CAMPUS.getMsg(), code, mainOrgName, subOrgName, defaultServerPhone);
        return content;
    }

    /**
     * 创建修改主账号手机号
     *
     * @param code
     * @param timeStep
     * @return
     */
    public static String createModOrgMobileSms(String code, int timeStep) {
        return String.format(TxSmsCodeType.MOD_ORG_MOBILE.getMsg(), code, timeStep, defaultServerPhone);
    }

    /**
     * 银行卡解绑
     *
     * @param orgName
     * @param card
     * @return
     */
    public static String createUnBindBankCard(String orgName, String card) {
        orgName = replaceSpecialSign(orgName);
        return String.format(TxSmsCodeType.ORG_BANK_UNBIND_CARD.getMsg(), orgName, card, defaultServerPhone);
    }

    /**
     * 银行卡绑定
     *
     * @param orgName
     * @param card
     * @return
     */
    public static String createBindBankCard(String orgName, String card) {
        orgName = replaceSpecialSign(orgName);
        return String.format(TxSmsCodeType.ORG_BANK_BIND_CARD.getMsg(), orgName, card, defaultServerPhone);

    }

    /**
     * 老师课表
     */
    public static String createTeacherClassSchedule(String orgCourseName, String orgName, String url) {
        orgName = replaceSpecialSign(orgName);
        orgCourseName = replaceSpecialSign(orgCourseName);
        orgCourseName = solveLength(orgCourseName, MAX_COURSE_NAME_LENGTH);
        orgName = solveLength(orgName, MAX_ORG_NAME_LENGTH);
        return createClassSchedule(orgCourseName, orgName, url);
    }

    /**
     * 学生课表
     */
    public static String createStudentClassSchedule(String orgCourseName, String orgName, String url) {
        orgName = replaceSpecialSign(orgName);
        orgCourseName = replaceSpecialSign(orgCourseName);
        orgCourseName = solveLength(orgCourseName, MAX_COURSE_NAME_LENGTH);
        orgName = solveLength(orgName, MAX_ORG_NAME_LENGTH);
        return createClassSchedule(orgCourseName, orgName, url);
    }

    /**
     * 上课提醒
     *
     * @param classTime
     * @param orgCourseName
     * @param orgName
     * @return
     */
    public static String createClassNotify(long classTime, String orgCourseName, String orgName) {
        String classTimeStr = formatCourseTime(classTime, true);
        orgName = replaceSpecialSign(orgName);
        orgCourseName = replaceSpecialSign(orgCourseName);
        orgName = solveLength(orgName, MAX_ORG_NAME_LENGTH);
        orgCourseName = solveLength(orgCourseName, MAX_COURSE_NAME_LENGTH);
        return String.format(TxSmsCodeType.CLASS_NOTIFY.getMsg(), classTimeStr, orgCourseName, orgName);
    }

    /**
     * V直播发言
     *
     * @param code
     * @param timeStep
     * @return
     */
    public static String createVZBSpeak(String code, int timeStep) {
        return String.format(TxSmsCodeType.VZHIBO_CONSULT_MOBILE_KEY.getMsg(), code, timeStep, defaultServerPhone);
    }

    /**
     * 生成生日提醒短信(机构使用全称)
     *
     * @param studentName
     * @param orgName
     * @return
     */
    public static String createBirthdaySmsMsg(String studentName, String orgName) {
        orgName = replaceSpecialSign(orgName);
        studentName = replaceSpecialSign(studentName);
        studentName = solveLength(studentName, MAX_TEACHER_NAME_LENGTH);
        return String.format(TxSmsCodeType.BIRTHDAY_NOTIFY.getMsg(), studentName, orgName);
    }

    /**
     * 生成报名短信
     * <p>
     * 如果是1门课，不显示“等X门课程”，1门以上的，显示第一门的课程名称+“等X门课程”。
     *
     * @param courseName
     * @param orgName
     * @return
     */
    public static String createSignupCourseSmsMsg(String courseName, int courseCount, String orgName) {
        courseName = replaceSpecialSign(courseName);
        orgName = replaceSpecialSign(orgName);
        orgName = solveLength(orgName, MAX_ORG_NAME_LENGTH);
        courseName = solveLength(courseName, MAX_COURSE_NAME_LENGTH);
        if (courseCount > 1) {
            return String.format(TxSmsCodeType.SIGNUP_NOTIFY_WITH_MANY.getMsg(), courseName, courseCount, orgName);
        }
        return String.format(TxSmsCodeType.SIGNUP_NOTIFY_WITH_SIGNAL.getMsg(), courseName, orgName);
    }


    /**
     * 生成签到成功短信
     * <p>
     * 到课通知：王小小同学，4月12日 11:15『数学一年级数学一年级数…』已到课。〖高峰教育123高峰…〗 <br/>
     * 到课通知：王小小同学，4月12日 11:15 已到课。〖高峰教育123高峰…〗 <br/>
     * 请假通知：王小小同学，4月12日 11:15 『数学一年级数学一年级数…』已请假。〖高峰教育123高峰…〗 <br/>
     * 未到课通知：王小小同学，4月12日 11:15 『数学一年级数学一年级数…』未到课。〖高峰教育123高峰…〗
     *
     * @return
     */
    public static String createSignRecordSmsMsg(int type, String studentName, Long courseTime, String courseName,
                                                String orgName) {
        studentName = replaceSpecialSign(studentName);
        studentName = solveLength(studentName, MAX_TEACHER_NAME_LENGTH);
        courseName = replaceSpecialSign(courseName);
        orgName = replaceSpecialSign(orgName);
        String courseTimeStr = null == courseTime ? "-" : formatCourseTime(courseTime, true);
        courseName = solveLength(courseName, MAX_COURSE_NAME_LENGTH);
        orgName = solveLength(orgName, MAX_ORG_NAME_LENGTH);
        TxSmsCodeType typeEnum = TxSmsCodeType.SIGN_NOTIFY_PRESENT;
        if (StringUtils.isEmpty(courseName) && type == 1) {
            return String.format(TxSmsCodeType.SIGN_NOTIFY_NOCOURSE_PRESENT.getMsg(), studentName, courseTimeStr, orgName);
        }
        if (type == 2) {
            typeEnum = TxSmsCodeType.SIGN_NOTIFY_LEAVE;
        } else if (type == 3) {
            typeEnum = TxSmsCodeType.SIGN_NOTIFY_NOT_PRESENT;
        }
        return String.format(typeEnum.getMsg(), studentName, courseTimeStr, courseName, orgName);
    }

    /**
     * 创建评价提醒
     * <p>
     * <p>
     * 老师名称最长7个字符，超过用6个字符+…
     *
     * @param teacherName
     * @param courseTime
     * @param url
     * @return
     */
    public static String createCommentNotifySmsMsg(String teacherName, long courseTime, String orgName, String url) {
        teacherName = replaceSpecialSign(teacherName);
        orgName = replaceSpecialSign(orgName);
        teacherName = solveLength(teacherName, MAX_TEACHER_NAME_LENGTH);
        orgName = solveLength(orgName, 7);
        String courseTimeStr = formatCourseTime(courseTime, false);
        // url = getShortUrl(url); //外层好像已经处理成短链了
        return String.format(TxSmsCodeType.COMMENT_NOTIFY.getMsg(), teacherName, courseTimeStr, url, orgName);
    }

    /**
     * 创建提醒学员给老师打分短信
     * <p>
     * <p>
     * 机构名用中格式，最长8个字符，超过用7个字符+…表示
     *
     * @return
     */
    public static String createNotifyCommentToStuSmsMsg(String teacherName, long courseTime, String url,
                                                        String orgName) {
        teacherName = solveLength(teacherName, MAX_TEACHER_NAME_LENGTH);
        orgName = solveLength(orgName, 7);
        String courseTimeStr = formatCourseTime(courseTime, false);
        return String.format(TxSmsCodeType.NOTIFY_TO_COMMENT.getMsg(), courseTimeStr, teacherName, url, orgName);
    }


    public static String createRechargeSms(String studentName, long createTime, Double money, String orgName) {
        String createTimeStr = formatCourseTime(createTime, true);
        orgName = solveLength(orgName, 7);
        return String.format(TxSmsCodeType.RECHARGE_SMS_CODE.getMsg(), studentName, createTimeStr, money, orgName);
    }

    public static String createTimescardSms(long createTime, int lessonCount, Date endTime, String orgName) {
        String createTimeStr = formatCourseTime(createTime, true);
        String endTimeStr = formatYearTime(endTime.getTime(), false);

        orgName = solveLength(orgName, 7);
        if (lessonCount < 0) {
            return String.format(TxSmsCodeType.TIMECARD_SMS_CODE_NO_COUNT.getMsg(), createTimeStr, endTimeStr, orgName);
        } else {
            return String.format(TxSmsCodeType.TIMECARD_SMS_CODE_COUNT.getMsg(), createTimeStr, lessonCount, orgName);
        }
    }

    public static String createTimescardValid(long endTime, String orgName) {
        String endTimeStr = formatCourseTime(endTime, false);

        orgName = solveLength(orgName, 7);
        return String.format(TxSmsCodeType.TIMECARD_VALID.getMsg(), endTimeStr, orgName);
    }

    public static String createTimescardDelay(Date delayDate, String orgName) {
        orgName = solveLength(orgName, 7);
        return String.format(TxSmsCodeType.TIMECARD_DELAY.getMsg(), DateUtil.getStrByDate(delayDate), orgName);
    }

    public static String createTimescardExhausted(String orgName) {
        orgName = solveLength(orgName, 7);
        return String.format(TxSmsCodeType.TIMECARD_EXHAUSTED.getMsg(), orgName);
    }

    /**
     * 学员/老师 绑定个人中心短信验证码
     *
     * @param code
     * @param timeStep
     * @param orgName
     * @return
     */
    public static String createBindWeixinSmsMsg(String code, int timeStep, String orgName) {
        orgName = replaceSpecialSign(orgName);
        orgName = solveLength(orgName, MAX_ORG_NAME_LENGTH);
        return String.format(TxSmsCodeType.BIND_WEIXIN.getMsg(), code, timeStep, orgName);
    }
    
    public static String createUCChangeMobileSmsMsg(String code, int timeStep, String orgName){
        orgName = replaceSpecialSign(orgName);
        orgName = solveLength(orgName, MAX_ORG_NAME_LENGTH);
        return String.format(TxSmsCodeType.USERCENTER_CHANGE_MOBILE.getMsg(), code, timeStep, orgName);
    }

    public static String createUCBindStuSmsMsg(String code, int timeStep, String orgName){
        orgName = replaceSpecialSign(orgName);
        orgName = solveLength(orgName, MAX_ORG_NAME_LENGTH);
        return String.format(TxSmsCodeType.USERCENTER_BIND_STU.getMsg(), code, timeStep, orgName);
    }

    /**
     * 营销群发短信
     *
     * @return
     */
    public static String createMarktingSmsMsg(String content, String branchSchoolName) {
        return String.format(TxSmsCodeType.TX_MARKTING_SMS.getMsg(), content, branchSchoolName);
    }

    /**
     * 验证码
     *
     * @param code
     * @param
     * @return
     */
    public static String createTxCodeMsg(String code) {
        return String.format(TxSmsCodeType.TX_VERTY_CODE.getMsg(), code);
    }

    /**
     * 电话咨询
     *
     * @param name
     * @param phone
     * @return
     */
    public static String createConsultRecall(String name, String phone) {
        name = replaceSpecialSign(name);
        return String.format(TxSmsCodeType.TX_CONSULT_RECALL.getMsg(), name, phone);
    }

    /**
     * 联系人电话咨询
     *
     * @param name
     * @param contact
     * @param phone
     * @return
     */
    public static String createConsultRecallContact(String name, String contact, String phone) {
        name = replaceSpecialSign(name);
        contact = replaceSpecialSign(contact);
        return String.format(TxSmsCodeType.TX_CONSULT_RECALL_CONTACT.getMsg(), name, contact, phone);
    }

    /**
     * 获取天校APP下载地址
     *
     * @return
     */
    public static String getAppDownload() {
        try {
            String url = PropertiesReader.getValue("tianxiao", "message.url");
            return ShortUrlUtil.getShortUrl(url, true);
        } catch (Exception e) {
            log.error("error :{} ", e);
            return defaultDownUrl;
        }
    }

    /**
     * @param url
     * @return
     */
    public static String getShortUrl(String url) {
        if (GenericsUtils.isNullOrEmpty(url)) {
            return "";
        }
        try {
            return ShortUrlUtil.getShortUrl(url, true);
        } catch (Exception e) {
            return "";
        }
    }

    /**
     * @param orgName
     * @param url
     * @return
     */
    private static String createClassSchedule(String courseName, String orgName, String url) {
        url = ShortUrlUtil.getShortUrl(url, true);
        return String.format(TxSmsCodeType.TEACHER_CLASS_SCHEDULE.getMsg(), courseName, url, orgName);
    }

    private static final String COURSE_TIME_FORMAT = "MM月dd日 HH:mm";
    private static final String COURSE_TIME_FORMAT_NOT_MH = "MM月dd日";

    /**
     * @param classTime
     * @return
     */
    private static String formatCourseTime(long classTime, boolean needHM) {
        SimpleDateFormat format = null;
        if (needHM) {
            format = new SimpleDateFormat(COURSE_TIME_FORMAT);
        } else {
            format = new SimpleDateFormat(COURSE_TIME_FORMAT_NOT_MH);
        }
        return format.format(new Date(classTime));
    }


    private static final String YEAR_TIME_FORMAT = "YYYY年MM月dd日 HH:mm";
    private static final String YEAR_TIME_FORMAT_NOT_MH = "YYYY年MM月dd日";

    /**
     * @param classTime
     * @return
     */
    private static String formatYearTime(long classTime, boolean needHM) {
        SimpleDateFormat format = null;
        if (needHM) {
            format = new SimpleDateFormat(YEAR_TIME_FORMAT);
        } else {
            format = new SimpleDateFormat(YEAR_TIME_FORMAT_NOT_MH);
        }
        return format.format(new Date(classTime));
    }

    /**
     * @param orgName
     * @return
     */
    private static String solveLength(String orgName, int length) {
        int infoLength = orgName.length();
        if (infoLength > length) {
            orgName = orgName.substring(0, length) + "...";
        }
        return orgName;
    }

    private static String replaceSpecialSign(String str) {
        return null == str ? "" : str.replaceAll("【", "[").replaceAll("】", "]");
    }

    public static void main(String[] args) {
        //System.out.println(solveLength("富强民主文明和谐自由平等公正法治哈哈哈", MAX_ORG_NAME_LENGTH));
        System.out.print(SmsContentHelper.createBindBankCard("sdfdsf", "12321321"));
    }

}
