package com.baijia.tianxiao.upload;

import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/4/25.
 */
@Slf4j
public class AliyunUploadUtil {
    public static UploadResult uploadToRemote(String url,String uid, File file, boolean watermark) {
        long start = System.currentTimeMillis();

        Map<String, File> files = Maps.newHashMap();
        Map<String, String> params = Maps.newHashMap();
        files.put("upfile", file);
        params.put("uid",uid);
        if (watermark) {
            url = url + "?watermark=1";
        }
        String response = HttpClientUtils.doPostFiles(url, params, files);
        log.debug("doUpload - uid:{}, file:{}, response:{}", uid, file, response);

        long end = System.currentTimeMillis();
        log.info("UploadService.uploadToRemote: uid:{},cost:{}", uid, (end - start));
        UploadResult result =  parseResponse(response);
        return result;
    }

    public static UploadResult parseResponse(String response) {
        if (StringUtils.isBlank(response)) {
            return null;
        }
        UploadResult uploadResult = new Gson().fromJson(response, UploadResult.class);
        return uploadResult;
    }
}
