/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.exception;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;


/**   
 * @Title       : PermissionException 
 * @Description : 权限异常
 * @Author      : zhenyujian
 * @Date        : 2015年12月1日 下午2:44:05 
 */
public class PermissionException extends CustomException {
    
	private static final long serialVersionUID = -1862735935420232493L;
	
	private static final UniverseErrorCode DEFAULT_ERRORCODE = CommonErrorCode.PERMISSION_DENY;

    
    public PermissionException(UniverseErrorCode errorCode) {
        this.errorCode = errorCode;
    }
    
    public PermissionException(String message) {
    	this.errorCode = DEFAULT_ERRORCODE;
        this.message = message;
    }
    
    public PermissionException(UniverseErrorCode errorCode, String message) {
        this.message = message;
        this.errorCode = errorCode;
    }
    
    public PermissionException(){
    	this.errorCode = DEFAULT_ERRORCODE;
    }
    
}




