package com.baijia.tianxiao.excel;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

import com.baijia.tianxiao.beanCopy.BeanInvokeUtils;
import com.baijia.tianxiao.beanCopy.BeanMethodInvoke;
import com.baijia.tianxiao.beanCopy.Invoker;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Dec 13, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
@Data
public class AbstractExpoter<T> implements Excelable<T>, MapperAble<String, Object> {

    private String headStrs;
    private String fieldStrs;
    private Map<String, Object> paramMap = new HashMap<>();

    private ExcelCell[] FIELDS_NAME;

    private ExcelHandler excleHandler;
    private Map<String, Invoker<Object>> fieldReaderCache = Maps.newHashMap();

    private static ConcurrentMap<Object, AbstractExpoter<?>> abstractExpoters = Maps.newConcurrentMap();

    @SuppressWarnings("unchecked")
    public static <T> AbstractExpoter<T> putIfAbs(Class<T> clazz) {
        AbstractExpoter<?> ae = null;
        if (!abstractExpoters.containsKey(clazz)) {
            log.info("can not find AbstractExpoter with clazz:{} ", clazz.getName());
            synchronized (String.valueOf(clazz.getName())) {
                if (!abstractExpoters.containsKey(clazz)) {
                    ae = new AbstractExpoter<>(clazz);
                    log.info("AbstractExpoter with clazz:{} is:{} ", clazz.getName(), ae);
                    abstractExpoters.put(clazz, ae);
                }
            }
        } else {
            ae = abstractExpoters.get(clazz);
        }
        return (AbstractExpoter<T>) ae;
    }

    public AbstractExpoter() {
    }

    /**
     * 
     * @param headStrWithSeparatorComma :将Excel表格头的名称连接成字符串，以逗号分开
     * @param fieldStrsWithSeparatorComma ：将Excel中需要显示字段的值对应的对象中的属性名称连接起来，以逗号分开<br/>
     *            eg: private String type;//线索类型 private String name;//机构简称（老师名称） private String visitType;//跟进类型
     *            private String visitTime;//跟进时间（YYYY-MM-DD hh:mm） private String visitor;//跟进人 private String
     *            visitStatus;//跟进进度 private String location;//地理位置 private String content;//跟进内容
     * 
     *            headStrWithSeparatorComma : 线索类型,线索简称,跟进类型,跟进时间,跟进人,跟进进度,地理位置,跟进内容
     *            fieldStrsWithSeparatorComma:type,name,visitType,visitTime,visitor,visitStatus,location,content
     * 
     *            =================================================================================== <br/>
     *            且对于一些字面值同属性实际的值不一致的属性对应的Excle列上的值，可以通过 当前对象的put(key,value)进行覆盖， key 为 属性的名称， value 为根据属性实际值获取的字面表示值
     * 
     * 
     * @param excelHandler : 如果需要对特定属性进行单独处理，通过该对象进行处理注册，默认是使用属性的value 填充ExcelCell 的value
     */
    public AbstractExpoter(String headStrWithSeparatorComma, String fieldStrsWithSeparatorComma,
        ExcelHandler excelHandler) {
        init(headStrWithSeparatorComma, fieldStrsWithSeparatorComma, excelHandler);
    }

    private void init(String headStrWithSeparatorComma, String fieldStrsWithSeparatorComma,
        ExcelHandler excelCellHandler) {
        this.headStrs = headStrWithSeparatorComma;
        this.fieldStrs = fieldStrsWithSeparatorComma;

        if (GenericsUtils.isNullOrEmpty(this.headStrs) || GenericsUtils.isNullOrEmpty(this.fieldStrs)) {
            throw new IllegalArgumentException("heads's length  is not match with fields's length");
        }

        String[] headNames = this.headStrs.split(",");
        String[] fieldNames = this.fieldStrs.split(",");

        if (GenericsUtils.notNullAndEmpty(fieldNames) && GenericsUtils.notNullAndEmpty(headNames)) {
            if (headNames.length != fieldNames.length) {
                throw new IllegalArgumentException("The length does not match between cellHeads and field");
            }
        } else {
            throw new IllegalArgumentException("can not fill a ExcelCell with those arguments");
        }

        this.FIELDS_NAME = new ExcelCell[headNames.length];

        for (int i = 0; i < FIELDS_NAME.length; i++) {
            String head = headNames[i];
            ExcelCellStyle style = new ExcelCellStyle();
            style.setBoldWeight((short) (20 * 256));
            this.FIELDS_NAME[i] = new ExcelCell(head, ExcelCellStyle.HEAD_STYLE);

        }
        this.excleHandler = excelCellHandler;
    }

    public AbstractExpoter(final String headStrs, final String fieldStrs) {
        this(headStrs, fieldStrs, new ExcelHandler() {
            {
                String[] fields = fieldStrs.split(",");
                this.batchRegisterHandler(fields, ExcelType.GENERAL);
            }
        });
    }

    /**
     * 通过注解来完成，在类上标注@ExcelExporterDto来表明当前类为一个Excel导出类对象
     * 
     * @ExcelExporterDto public class ExporterDto { @ExcelColumn("线索类型") private String type;//线索类型 @ExcelColumn("机构简称")
     *                   private String name;// 机构简称（老师名称） @ExcelColumn("跟进类型") private String visitType;//
     *                   跟进类型 @ExcelColumn("跟进时间") private String visitTime;// 跟进时间（YYYY-MM-DD
     *                   hh:mm） @ExcelColumn("跟进人") private String visitor;// 跟进人 @ExcelColumn("跟进进度") private String
     *                   visitStatus;// 跟进进度 @ExcelColumn("地理位置") private String location;// 地理位置 @ExcelColumn("跟进内容")
     *                   private String content;// 跟进内容 }
     */
    public AbstractExpoter(Class<T> clazz) {
        Annotation excelExporterAnnt = clazz.getAnnotation(ExcelExporterDto.class);
        if (excelExporterAnnt != null) {
            this.excleHandler = new ExcelHandler();
            resolve(clazz);
        } else {
            throw new IllegalArgumentException(
                String.format("Cannot resolve this class:%s cause by not mark with annotation:%s  ", clazz,
                    ExcelExporterDto.class.getName()));
        }

    }

    @SuppressWarnings("unchecked")
    private void resolve(Class<T> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        StringBuilder headsStr = new StringBuilder();
        StringBuilder fieldsStr = new StringBuilder();
        BeanMethodInvoke<Object> findBeanMethodInovker =
            (BeanMethodInvoke<Object>) BeanInvokeUtils.findBeanMethodInovker(clazz);
        for (Field field : fields) {
            ExcelColumn annt = field.getAnnotation(ExcelColumn.class);
            if (annt != null) {
                String fieldName = field.getName();
                try {
                    Invoker<Object> fieldReader = findBeanMethodInovker.getFieldReader(fieldName);
                    this.fieldReaderCache.put(fieldName, fieldReader);
                } catch (Exception e) {
                    log.info("can not find fieldReader for clazz:{} with fieldName :{} ", clazz, fieldName);
                    continue;
                }
                String headName = annt.value();
                ExcelType excelType = annt.excelType();
                if (excelType == null) {
                    excelType = ExcelType.GENERAL;
                } else if (excelType == ExcelType.DATE) {
                    this.excleHandler.registerTimeFormat(fieldName, annt.dataFormat());
                }
                this.excleHandler.registerHandler(fieldName, excelType);
                headsStr.append(headName).append(",");
                fieldsStr.append(fieldName).append(",");
            }
        }
        final String headTemp = GenericsUtils.deleteLastCharToString(headsStr);
        final String fieldTemp = GenericsUtils.deleteLastCharToString(fieldsStr);
        this.init(headTemp, fieldTemp, this.excleHandler);

    }

    @Override
    public ExcelCell[] exportRowName() {
        return this.FIELDS_NAME;
    }

    @Override
    public ExcelCell[] exportRowValue(T row) {
        ExcelCell[] values = new ExcelCell[FIELDS_NAME.length];
        String fieldNamesBySort = this.fieldStrs;
        String[] fieldNames = fieldNamesBySort.split(",");

        if (row instanceof InitAble) {
            ((InitAble) row).initProperties();
        }

        Map<String, Object> fieldValueMapper = createValueMap(row, fieldNames); // BeanInvokeUtils.copyToMap(row,
        // filedNames);
        // 客户端在执行这行之前需要先对默认值进行覆盖
        this.paramMap.putAll(fieldValueMapper);
        this.setValues(values, fieldValueMapper, fieldNames);
        return values;

    }

    /**
     * @param fieldNames
     * @return
     */
    private Map<String, Object> createValueMap(T row, String[] fieldNames) {
        if (GenericsUtils.isNullOrEmpty(fieldNames)) {
            return BeanInvokeUtils.copyToMap(row, fieldNames);
        }
        Map<String, Object> retValueMap = Maps.newHashMapWithExpectedSize(fieldNames.length);
        for (String fieldName : fieldNames) {
            Invoker<Object> invoker = this.fieldReaderCache.get(fieldName);
            if (invoker != null) {
                try {
                    retValueMap.put(fieldName, invoker.invoke(row));
                } catch (Exception e) {
                    log.info("can not read field's {} value cause by :{} ", fieldName, e);
                }
            }
        }
        return retValueMap;
    }

    private void setValues(ExcelCell[] values, Map<String, Object> fieldValueMapper, String...fieldNames) {
        int i = 0;
        if (GenericsUtils.notNullAndEmpty(fieldNames)) {
            for (String fieldName : fieldNames) {
                Object value = fieldValueMapper.get(fieldName);
                log.debug("fieldName :{} and value is :{} ", fieldName, value);
                values[i] = this.excleHandler.getExcelValue(fieldName, value);
                i++;
            }
        }
    }

    /**
     * 获取当前ExcelExporter对象的列值处理器，可以使用该对象来为特定的属性注册不同的列处理方式
     * 
     * @return
     */
    public ExcelHandler getHandler() {
        return this.excleHandler;
    }

    /**
     * 这个方法的调用用于覆盖对象中默认保存的数据，且该方法必须在调用exportRowValue(T row)方法之前调用，否则覆盖会无效
     */
    @Override
    public void put(String key, Object value) {
        // 在到处之前需要提前进行默认值的覆盖
        this.paramMap.put(key, value);
    }

    public void initOthers() {
    }

}
