/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.util.ErrorCodeUtil;

/**
 * @title ErrorCode
 * @desc TODO
 * @author macrohuang
 * @date Nov 11, 2015
 * @version 1.0
 */
public enum CommonErrorCode implements UniverseErrorCode {

    UNKNOW(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 1, "未知类型错误"),

    PARAM_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 400, "请求参数不合法"),

    REQUIRE_PARAM(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 401, "缺少必要的请求参数"),

    SIGN_INVALIDATE(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 402, "参数检验不通过"),

    INVALIDATE_CLIENTID(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 403, "clientId不合法"),

    TOKEN_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 408, "TOKEN不合法"),

    // 约定: 前端接受到这个错误码 跳转通用版登录页
    NO_LOGIN(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 500, "通用版用户未登录"),

    // 约定: 前端接受到这个错误码 跳转网校登录页
    NO_LOGIN_ONLINE_ORG(ErrorSide.SERVER, Subsystem.WANGXIAO, Platform.PC, 501, "网校版用户未登录"),
    
    NO_LOGIN_STUDENT_CENTER(ErrorSide.SERVER, Subsystem.STUDENT_CENTER, Platform.M, 502, "学生个人中心未登录"),
    
    NO_LOGIN_TEACHER_CENTER(ErrorSide.SERVER, Subsystem.TEACHER_CENTER, Platform.M, 503, "老师个人中心未登录"),

    REQUEST_EXCEED(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 300, "超出请求次数限制"),

    NOT_FOUND(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 404, "所请求资源不存在"),

    IO_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 600, "后台处理IO异常"),

    PERMISSION_DENY(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 700, "无请求该资源权限"),

    // 约定: 前端接受到这个错误码 跳转分校
    PERMISSION_DENY_AND_JUMP(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.PC, 701, "总校资源,分校无权限访问"),

    // 约定: 前端接受到这个错误码 跳转网校
    PERMISSION_DENY_AND_JUMP_WANGXIAO(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.PC, 702, "总校资源,网校无权限访问"),

    BUSINESS_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 800, "业务处理异常"),

    NEED_RE_LOGIN(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 900, "权限已变更，请重新登录"),

    SYSTEM_ERROR(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 9999, "系统处理异常");

    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private CommonErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public CommonErrorCode fromCode(int code) {
        for (CommonErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return CommonErrorCode.UNKNOW;
    }

    public static void main(String args[]) {
        System.out.println(ErrorCodeUtil.getUniverseErrorCode(NEED_RE_LOGIN));
    }
}
