
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.constants.sms;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time May 19, 2017
 * @Desc this guy is too lazy, nothing left.
 */
public enum TxWechatTemplateMsgType {

    //签到提醒
    SIGNUP_WECHAT_TEMPLATE(1, "签到成功提醒", "%s同学在%s课程%s。\n上课时间为%s\n", "\n请点击消息查看课表，如果对签到情况有疑问，您可致电4000122166转%s",
        new String[] { "学生姓名", "签到时间", "签到课程", "上课老师" },"学生课表"),
    //课程通知提醒
    COURSE_NOTIFY_WECHAT_TEMPLATE(2, "课程通知提醒",
            "%s同学在%s课程即将开始，请做好上课准备并按时到课哦~\n", "\n请点击消息查看课表，如果对课程安排有疑问，您可致电4000122166转%s",
            new String[] { "上课时间", "老师名字", "课程名称", "上课教室" },"学生课表"),
    //课后评价提醒
    AFTER_COURSE_COMMENT_WECHAT_TEMPLATE(3, "课后评价提醒",
        "%s同学在%s的课程已完成。\n对老师本节课的表现感觉如何？有什么想说的请告诉我们吧~\n", "\n请点击消息给老师写评价吧~",
        new String[] { "学员姓名", "课程名称", "主讲老师" },"评价页面"),
    //课后点评提醒
    AFTER_COURSE_COMMENT_NOTIFY_WECHAT_TEMPLATE(4, "课后点评提醒",
        "%s老师点评了您在%s的课堂表现，快去看看吧！\n", "\n请点击消息给老师写评价吧~",
        new String[] { "学员姓名", "课程名称", "主讲老师" },"评价页面"),

    ;

    public int code;
    public String desc;
    public String first;
    public String firstColor = "#27B2ED";
    public String remark;
    public String remarkColor = "#27B2ED";
    public String[] keywords;
    public String keywordColor = "#878788";
    public String url = "";

    /**
     * @param code
     * @param desc
     * @param first
     * @param remark
     * @param keywords
     */
    private TxWechatTemplateMsgType(int code, String desc, String first, String remark, String[] keywords, String url) {
        this.code = code;
        this.desc = desc;
        this.first = first;
        this.remark = remark;
        this.keywords = keywords;
        this.url = url;
    }

    private TxWechatTemplateMsgType(int code, String desc, String first, String remark, String[] keywords) {
        this.code = code;
        this.desc = desc;
        this.first = first;
        this.remark = remark;
        this.keywords = keywords;
    }

}
