/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.constants.signup;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/**
 * @title SplitCourseResult
 * @desc 拆分课程结果
 * @author cxm
 * @date 2015年9月15日
 * @version 1.0
 */
public enum SplitCourseResult {

    NOT_COMMIT(-1, "已付款,未报名"),

    PENDING(0, "待拆分"),

    SUCCESS(1, "拆分成功"),

    FAIL(2, "拆分失败"),

    ;

    private int code;

    private String note;

    private static Map<Integer, SplitCourseResult> map = Maps.newHashMap();

    private SplitCourseResult(int code, String note) {
        this.code = code;
        this.note = note;
    }

    static {
        for (SplitCourseResult splitResult : SplitCourseResult.values()) {
            map.put(splitResult.code, splitResult);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static SplitCourseResult getSplitCourseResultByCode(Integer code) {
        return map.get(code);
    }
    
    public static List<Integer> getSplitResultList(Integer code){
       if(code!=null){
           List<Integer> list = Lists.newArrayList();
           if(code.intValue()!=1){
               list.add(-1);
               list.add(0);
               list.add(2);
               return list;
           }else{
               list.add(1);
               return list;
           }
       }
       return null;
    }
}
