package com.baijia.tianxiao.constants;


import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 
 * @title UserRoleEnum
 * @desc TODO
 * @author cxm
 * @date 2015年9月11日
 * @version 1.0
 */
public enum UserRoleEnum {

    ANONYMOUS(-1, "匿名"),

    TEACHER(0, "老师"), //

    STUDENT(2, "学生"), //

    ORG(6, "机构"),

    KEFU(7, "客服"),

    CUSTOMER(8, "客户"), // 不在学生,老师,机构列表的电话,电话跟进中都是这种

    System(100, "系统信息"),

    Admin(101, "群组管理通知"),

    Operator(127, "师资"),

    ;

    private static final Map<Integer, UserRoleEnum> map = Maps.newHashMap();

    static {
        for (UserRoleEnum userRole : UserRoleEnum.values()) {
            map.put(userRole.getCode(), userRole);
        }
    }

    private int code;
    private String note;

    private UserRoleEnum(int code, String note) {
        this.code = code;
        this.note = note;
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static String getNote(Integer code) {
        if (map.containsKey(code)) {
            return map.get(code).getNote();
        }
        return null;
    }

    public static UserRoleEnum getByCode(Integer code) {
        return map.get(code);
    }
}
