
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.util.bean;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @title BizDateThreadLocalUtil
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年11月10日
 * @version 1.0
 */

public class BizDateThreadLocalUtil {

    public static final ThreadLocal<Map<String, Object>> cache = new ThreadLocal<Map<String, Object>>() {
        @Override
        protected Map<String, Object> initialValue() {
            return Maps.newHashMap();
        }
    };
    
    
    public static <T> void set(String key, T value){
        cache.get().put(key, value);
    }
    
    public static Object get(String key){
        return cache.get().get(key);
    }
    
    @SuppressWarnings("unchecked")
    public static <T> T get(String key, Class<T> clazz){
        return (T) cache.get().get(key);
    }
    
    public static void clear(){
        cache.remove();
    }
}

    