package com.baijia.tianxiao.util;



import com.baijia.commons.lang.utils.http.HttpClientUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.*;

/**
 * Created by liuxp on 16/3/22.
 */
@Slf4j
public class HttpForwardUtil {
    public static final String CHARSET = "UTF-8";

    public static void forwardGet(HttpServletResponse response,HttpServletRequest request,String url){
        try {
            CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();
            HttpContext localContext = new BasicHttpContext();
            if (StringUtils.isNotBlank(getRequestParamStr(request))) {
                //url += "?" + CharacterUtils.decodeUnicode(getRequestParamStr(request));
            	url += "?" + getRequestParamStr(request);
            }
            log.info("[WechatUrl]=" + encodeUrl(url));
            HttpGet httpget = new HttpGet(encodeUrl(url));
            CloseableHttpResponse result = httpclient.execute(httpget, localContext);
            try {
//                Header[] headers = result.getAllHeaders();
//                if (headers != null) {
//                    for (Header header : headers) {
//                        log.info("[Header] header=" + header.getName() + ";value=" + header.getValue());
//                        response.setHeader(header.getName(), header.getValue());
//                    }
//                }
                log.info("[Result] Result Code=" + result.getStatusLine().getStatusCode());
                String string = EntityUtils.toString(result.getEntity(), CHARSET);
                log.info("[Result] Result Content="+string);
                response.getWriter().print(string);
                response.getWriter().flush();
            }finally {
                if (response != null) {
                    final HttpEntity entity = result.getEntity();
                    if (entity != null) {
                        try {
                            EntityUtils.consume(entity);
                        } catch (final IOException ex) {
                            log.error("[Exception]",ex);
                        }
                    }
                }
            }
        }catch (Exception e){
            log.error("[Exception]",e);
        }
    }

    public static void forwardPost(HttpServletResponse response,HttpServletRequest request,String url){
        try {
            CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();
            HttpContext localContext = new BasicHttpContext();
            log.info("[WechatUrl]=" + encodeUrl(url));
            Map<String,String> params = getRequestParamMap(request);
            List<NameValuePair> pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = new ArrayList<NameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value != null) {
                        pairs.add(new BasicNameValuePair(entry.getKey(), value));
                    }
                }
            }
            HttpPost httpPost = new HttpPost(encodeUrl(url));
            if (pairs != null && pairs.size() > 0) {
                httpPost.setEntity(new UrlEncodedFormEntity(pairs, CHARSET));
            }
            CloseableHttpResponse result = httpclient.execute(httpPost, localContext);
//            Header[] headers = result.getAllHeaders();
//            if (headers != null) {
//                for (Header header : headers) {
//                    response.setHeader(header.getName(), header.getValue());
//                }
//            }
            InputStream inputStream = result.getEntity().getContent();
            ServletOutputStream out = response.getOutputStream();
            log.info("[Result] Result Code="+result.getStatusLine().getStatusCode());
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }catch (Exception e){
            log.error("[Exception]",e);
        }
    }

    private static Map<String,String> getRequestParamMap(HttpServletRequest request){
        Enumeration<String> enums = request.getParameterNames();
        Map<String,String> map = new HashMap<>();
        while (enums.hasMoreElements()){
            String name = enums.nextElement();
            map.put(name, request.getParameter(name));
        }
        return map;
    }

    private static String getRequestParamStr(HttpServletRequest request){
        Enumeration<String> enums = request.getParameterNames();
        StringBuilder sb = new StringBuilder();
        while (enums.hasMoreElements()){
            String name = enums.nextElement();
            sb.append("&").append(name).append("=").append(request.getParameter(name));
        }
        if(sb.length()>0) {
            return sb.substring(1);
        }
        return sb.toString();
    }

    public static String encodeUrl(String urlStr) {
        try {
            URL url = new URL(urlStr);
            String nullFragment = null;
            URI uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), nullFragment);
            return uri.toString();
        } catch (MalformedURLException e) {
            log.error("URL " + urlStr + " is a malformed URL");
        } catch (URISyntaxException e) {
            log.error("URI " + urlStr + " is a malformed URL");
        }
        return urlStr;
    }
}
