package com.baijia.tianxiao.util;

import com.baijia.tianxiao.util.bean.LoggerService;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;

import com.google.common.base.Preconditions;

import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class CourseSmsTokenUtil {

    public static final int TOKEN_VERSION = 1;

    @Data
    public static class SmsToken {
        private Date ts;

        private Long orgId;

        private Map<String, Object> params = new HashMap<>();

        private Integer version;

        public void put(String key, Object value) {
            params.put(key, value);
        }
    }

    // public static String encodeToken(OrgCourseSms sms) throws Exception {
    // Preconditions.checkArgument(sms != null, "smsCourse is null");
    // Map<String, Object> token = new HashMap<>();
    // token.put("orgId", sms.getOrgId());
    // token.put("courseId", sms.getCourseId());
    // token.put("id", sms.getId());
    //
    // if (UserRole.STUDENT.getRole() == sms.getUserRole()) {
    // token.put("studentId", sms.getStudentId());
    // } else if (UserRole.TEACHER.getRole() == sms.getUserRole()) {
    // token.put("teacherId", sms.getUserId());
    // }
    // return encodeToken(token);
    // }

    public static String encodeToken(Map<String, Object> params) throws Exception {
        return encodeToken(params, (Long) params.get("orgId"));
    }

    public static String encodeToken(Map<String, Object> params, Long orgId) throws Exception {
        return encodeExpireToken(params, orgId, DateUtil.getDiffDateTime(new Date(), 2));
    }

    public static String encodeExpireToken(Map<String, Object> params, Long orgId, Date expireDate) throws Exception {
        Preconditions.checkArgument(params != null, "params is null");
        SmsToken token = new SmsToken();
        token.setOrgId(orgId);
        token.getParams().putAll(params);
        token.setTs(expireDate);
        token.setVersion(TOKEN_VERSION);
        return EncryptUtils.base64EncodeStrWithFactor(token);
    }

    public static SmsToken decodeToken(String token) throws Exception {
        if (StringUtils.isBlank(token)) {
            return null;
        }
        String jsonStr = EncryptUtils.strDecode(token);
        try {
            return JacksonUtil.str2Obj(jsonStr, SmsToken.class);
        } catch (Exception e) {
            log.warn("decode token error! token:{}, jsonStr:{}, e:{}", token, jsonStr, e);
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        String token =
            "H4Ipe3opQTg7QDw8OT05OTw-OTczKXZ5blBrKUE9ODo9OzQqeGl6aXV7KkKDKnxtaWtwbXpRbCpCOz9BOkA6QjUreHlud1JtK0MreHx5UlR8PUpbSlM-cVZsaHRgUlpfWFdSUn5UfSw2";
//        SmsToken t = decodeToken(token);
        String jsonStr = EncryptUtils.strDecode(token);
        System.out.println(jsonStr);
        

        String content = "{l_mac=1b99d794-9983-3b8e-b97a-adccbc605ff3, scheme=bjhltx, os=android-24, signature=ad6be8908a97e25d6\n"
            + "816d6d2c6f24242, channel=HuaWeiStore, pageSize=20, l_imei=863444032761062, uuid=1b99d794-9983-3b8e-b97a-adccbc605ff3, version=2.2.1, pageNum=1, platform=android-HUAWEI:FRD-AL10, startTime=1495296000141, logId=4\n"
            + "d97eb79-9aa4-420c-8514-19180b02e79a, endTime=1495382400141, auth_token=HYAnenhqd2RuaSc_Ozg8ODkxJ2h5Jz82OT46Ojo7Ojc9Mih5Z3J6KEAob3VNfzpWaD0oMih6fmVpZ3lqaGtsZnx6bHlmcGspQTo8PUAzKXt_ZmhqanZ8dXxncWwqQnZ9dHQ0KnyAZ35\n"
            + "xe3F8d3pncWwqQnZ9dXU1K2psbHh-d31fbnt8cnh3K0M6NStqeXlOd38sRCx5eHZzeG8sNix-gnB8eXdpeXxxaXNuLER4f3d3Ny1qUX16eGp4bH5_cH0tRXmAd3eI, timestamp=1495556428877}";
        
        String encodeStr = EncryptUtils.base64EncodeStrWithFactor(content);
        System.out.println(encodeStr);
        String decodeStr = EncryptUtils.strDecode(encodeStr);
        System.out.println(decodeStr);
        System.out.println(decodeStr.equals(content));

        System.out.println();
        
        encodeStr="BYAneXgnQDc6Pz49OD4_ODo_QD80K3h7cFJuLEQ_Ozw_PjctfG1-bXmAL0eIL4Jzb3F2dIFYczFKQ0NCRkdFSD0zgYJ3gFt3NU01gkR5gnyKiFhbZl1-hpBYTX1qhXhcYoVdgYSJWjtFO4mMgWN-PVVQTExQT0g-k4KAhX6RX46OZ4JBWUGWl1CCU4VZUlpXU4dZVlNVVFNFoE9FmomWl42Uk0dfVqM";
        System.out.println(decodeToken(encodeStr));
    }
}
