/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;

/**
 * @author caoliang
 * @version 1.0
 * @title SMSErrorCode
 * @desc O(∩_∩)O~
 * @date 2016年5月14日
 */

public enum SMSErrorCode implements UniverseErrorCode {

    UNKNOW(1001, "未知类型错误"),

    SMS_INTERVAL_ERROR(1002, "一分钟只能发送一次"),

    SMS_TYPE_INVALID(1003, "短信类型不合法"),

    CODE_INVALID(1004, "短信验证码错误");

    private int code;
    private String message;

    SMSErrorCode(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return ErrorSide.SERVER;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return Subsystem.COMMON;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return Platform.UNKNOW;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public SMSErrorCode fromCode(int code) {
        for (SMSErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return SMSErrorCode.UNKNOW;
    }

}
