/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.constants;

import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.google.common.collect.Maps;

/**
 * @title OrgCourstStatus
 * @desc TODO
 * @author cxm
 * @date 2015年9月9日
 * @version 1.0
 */
public enum OrgCourseStatus {
    IN_PROGRESS(0, "招生中"),

    OFFLINE(1, "已下架"),

    ;
    private static Map<Integer, OrgCourseStatus> map = Maps.newHashMap();
    static {
        for(OrgCourseStatus status:OrgCourseStatus.values()){
            map.put(status.getCode(), status);
        }
    }

    private int code;
    private String note;

    private OrgCourseStatus(int code, String note) {
        this.code = code;
        this.note = note;
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static OrgCourseStatus getByCode(int code) {
        return map.get(code);
    }
    
    public static String getNote(int code){
        OrgCourseStatus status = getByCode(code);
        if(status != null){
            return status.getNote();
        }
        
        return StringUtils.EMPTY;
    }

}
