/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUtil {
    private static final Logger log = LoggerFactory.getLogger(ListUtil.class);
    private static Logger logger = LoggerFactory.getLogger(ListUtil.class);

    public static <T> List<T> getSubList(List<T> list, int offset, int count) {
        if (offset < 0) {
            offset = 0;
        }
        if (list == null || list.size() - 1 < offset) {
            return new ArrayList();
        }
        int end = list.size() > offset + count ? offset + count : list.size();
        return list.subList(offset, end);
    }

    public static <K, V> void insertIntoMap(Map<K, V> map, List<K> keys, V value) {
        if (map != null && keys != null) {
            for (K key : keys) {
                map.put(key, value);
            }
        }
    }

    public static boolean allNull(Object first, Object ... objects) {
        if (first != null) {
            return false;
        }
        if (ArrayUtils.isEmpty((Object[])objects)) {
            return true;
        }
        for (Object o : objects) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static boolean allNotNull(Object first, Object ... objects) {
        if (first == null) {
            return false;
        }
        if (ArrayUtils.isEmpty((Object[])objects)) {
            return true;
        }
        for (Object o : objects) {
            if (o != null) continue;
            return false;
        }
        return true;
    }

    public static boolean hasNull(Object first, Object ... objects) {
        if (first == null) {
            return true;
        }
        if (ArrayUtils.isEmpty((Object[])objects)) {
            return false;
        }
        for (Object o : objects) {
            if (o != null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNotNull(Object first, Object ... objects) {
        if (first != null) {
            return true;
        }
        if (ArrayUtils.isEmpty((Object[])objects)) {
            return false;
        }
        for (Object o : objects) {
            if (o == null) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean in(T value, T ... list) {
        if (ArrayUtils.isEmpty((Object[])list)) {
            return false;
        }
        for (T t : list) {
            if (!ObjectUtils.equals(value, t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean notIn(T value, T ... list) {
        return !ListUtil.in(value, list);
    }

    public static boolean or(boolean ... values) {
        return BooleanUtils.or((boolean[])values);
    }

    public static boolean and(boolean ... values) {
        return BooleanUtils.and((boolean[])values);
    }

    public static <K, V> List<K> toKeyList(Collection<? extends V> list, String field, Class<V> clazz) {
        ArrayList<K> retList = new ArrayList<K>();
        if (list != null && list.size() > 0) {
            for (V value : list) {
                retList.add(ListUtil.getKey(value, field, clazz));
            }
        }
        return retList;
    }

    private static <K, V> K getKey(V value, String field, Class<V> clazz) {
        String method = "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
        Object key = null;
        try {
            key = clazz.getMethod(method, new Class[0]).invoke(value, new Object[0]);
        }
        catch (Exception e) {
            logger.warn("[Exception]", (Throwable)e);
        }
        return (K)key;
    }

    public static String converToString(String[] ig) {
        String str = "";
        if (ig != null && ig.length > 0) {
            for (int i = 0; i < ig.length; ++i) {
                str = str + ig[i] + ",";
            }
        }
        str = str.substring(0, str.length() - 1);
        return str;
    }

    public static String listToString(List list) {
        StringBuilder sb = new StringBuilder();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (i < list.size() - 1) {
                    sb.append(list.get(i) + ",");
                    continue;
                }
                sb.append(list.get(i));
            }
        }
        return sb.toString();
    }

    public static int BinSearch(Integer[] data, Integer key) {
        int low = 0;
        int high = data.length - 1;
        int mid = 0;
        if (data[low] == key) {
            return low;
        }
        if (data[high] == key) {
            return high;
        }
        while (low <= high) {
            mid = (low + high) / 2;
            if (data[mid] == key) {
                return mid;
            }
            if (data[mid] > key) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        if (low > high) {
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        Integer[] data = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        System.out.println(ListUtil.BinSearch(data, 3));
        System.out.print(256);
    }
}

