/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionHelper {
    private static final Logger log = LoggerFactory.getLogger(CollectionHelper.class);

    public static <T> Map<Long, T> toIdMap(Collection<T> collection) {
        return CollectionHelper.toKeyMap(collection, "id");
    }

    public static <T> Map<Long, T> toKeyMap(Collection<T> collection, final String key) {
        if (collection == null) {
            return new HashMap();
        }
        return CollectionUtils.extractMap(collection, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, T>(){

            public Long extract(T t) {
                try {
                    Field field = t.getClass().getDeclaredField(key);
                    field.setAccessible(true);
                    Long value = (Long)field.get(t);
                    return value;
                }
                catch (NoSuchFieldException e) {
                    log.error("ToKeyMap exception ", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error("ToKeyMap exception ", (Throwable)e);
                }
                throw new RuntimeException("ToKeyMap exception");
            }
        });
    }

    public static <T> String join(Collection<T> collection) {
        if (collection == null || collection.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (T t : collection) {
            sb.append(",").append(t.toString());
        }
        return sb.substring(1);
    }
}

