/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.upload;

import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunUploadUtil {
    private static final Logger log = LoggerFactory.getLogger(AliyunUploadUtil.class);

    public static UploadResult uploadToRemote(String url, String uid, File file, boolean watermark) {
        long start = System.currentTimeMillis();
        HashMap files = Maps.newHashMap();
        HashMap params = Maps.newHashMap();
        files.put("upfile", file);
        params.put("uid", uid);
        if (watermark) {
            url = url + "?watermark=1";
        }
        String response = HttpClientUtils.doPostFiles(url, params, files);
        log.debug("doUpload - uid:{}, file:{}, response:{}", new Object[]{uid, file, response});
        long end = System.currentTimeMillis();
        log.info("UploadService.uploadToRemote: uid:{},cost:{}", (Object)uid, (Object)(end - start));
        UploadResult result = AliyunUploadUtil.parseResponse(response);
        return result;
    }

    public static UploadResult parseResponse(String response) {
        if (StringUtils.isBlank((CharSequence)response)) {
            return null;
        }
        UploadResult uploadResult = (UploadResult)new Gson().fromJson(response, UploadResult.class);
        return uploadResult;
    }
}

