/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.beanCopy;

import com.baijia.tianxiao.util.GenericsUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecialNameRegistry {
    private static final Logger log = LoggerFactory.getLogger(SpecialNameRegistry.class);
    private AtomicInteger incr = new AtomicInteger(0);
    private ConcurrentHashMap<String, Integer> nameIds = new ConcurrentHashMap();
    private final String CLASS_NAME_PREFIX_FORMAT = "class:%s";
    private final String METHOD_NAME_PREFIX_FORMAT = "method:%s:%s:%s";
    private static SpecialNameRegistry instance = new SpecialNameRegistry();

    private SpecialNameRegistry() {
    }

    public static SpecialNameRegistry getInstance() {
        return instance;
    }

    public static String[] argumentTypesToString(Class<?>[] argTypes) {
        String[] argus = new String[argTypes.length];
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c = argTypes[i];
                argus[i] = c.getName();
            }
        }
        return argus;
    }

    public String getClassName(Integer num) {
        return this.findNameWithNum(num).get(0);
    }

    public List<String> getMethodName(Integer num) {
        return this.findNameWithNum(num);
    }

    private List<String> findNameWithNum(Integer num) {
        for (Map.Entry<String, Integer> entry : this.nameIds.entrySet()) {
            if (!entry.getValue().equals(num)) continue;
            return this.decodeClassName(entry.getKey());
        }
        return null;
    }

    private List<String> decodeClassName(String classNameWithPrefix) {
        String[] ret = classNameWithPrefix.split(":");
        List<String> infos = Arrays.asList(ret);
        return infos.subList(0, infos.size());
    }

    public Integer getClassId(String className) {
        String formatClassName = this.formatClassName(className);
        return this.getIdForName(formatClassName);
    }

    public Integer getClassIdAndAllocate(String className) {
        return this.getIdForNameAndAllocate(this.formatClassName(className), true);
    }

    public Integer getMethodId(String className, String methodName, String ... paramTypes) {
        return this.getIdForNameAndAllocate(this.formatMethodName(className, methodName, paramTypes), false);
    }

    public Integer getMethodIdAndAllocate(String className, String methodName, String ... paramTypes) {
        String methodMark = this.formatMethodName(className, methodName, paramTypes);
        log.info("methodMark name is : {} ", (Object)methodMark);
        return this.getIdForNameAndAllocate(methodMark, true);
    }

    private Integer getIdForName(String name) {
        return this.getIdForNameAndAllocate(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getIdForNameAndAllocate(String name, boolean allocate) {
        if (GenericsUtils.isNullOrEmpty(name)) {
            return null;
        }
        Integer num = this.nameIds.get(name);
        log.info("nameId is : {} and num is :{} ", (Object)name, (Object)num);
        if (num == null && allocate) {
            SpecialNameRegistry specialNameRegistry = instance;
            synchronized (specialNameRegistry) {
                num = this.incr.incrementAndGet();
                this.nameIds.putIfAbsent(name, num);
            }
        }
        return num;
    }

    private String formatClassName(String className) {
        if (GenericsUtils.isNullOrEmpty(className)) {
            return null;
        }
        return String.format("class:%s", className);
    }

    private String formatMethodName(String className, String methodName, String[] paramTypes) {
        if (GenericsUtils.isNullOrEmpty(className) || GenericsUtils.isNullOrEmpty(methodName)) {
            return null;
        }
        StringBuilder typeDescStr = new StringBuilder();
        if (GenericsUtils.notNullAndEmpty(paramTypes)) {
            for (String paramType : paramTypes) {
                typeDescStr.append(paramType).append(",");
            }
        }
        return String.format("method:%s:%s:%s", className, methodName, GenericsUtils.deleteLastChar(typeDescStr));
    }
}

