/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.base;

import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.util.WebResponseHelper;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class BaseController {
    private static final Logger log = LoggerFactory.getLogger(BaseController.class);

    @ExceptionHandler
    public WebResponse expHandle(HttpServletRequest request, Throwable ex) {
        if (ex instanceof IllegalArgumentException) {
            log.warn("BaseController IllegalArgumentException", ex);
            return WebResponseHelper.error(CommonErrorCode.PARAM_ERROR);
        }
        if (ex instanceof BussinessException) {
            log.warn("BaseController BussinessException", ex);
            return WebResponseHelper.error(CommonErrorCode.BUSINESS_ERROR, ex.getMessage());
        }
        if (ex instanceof PermissionException) {
            log.warn("BaseController PermissionException", ex);
            return WebResponseHelper.error(CommonErrorCode.PERMISSION_DENY);
        }
        log.error("BaseController Throwable =={}", ex);
        return WebResponseHelper.error(CommonErrorCode.SYSTEM_ERROR);
    }
}

