/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.date;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDate;
import org.springframework.web.util.HtmlUtils;

public class DateUtil {
    private static Map<Integer, String> chineseWeekDayMap = Maps.newHashMap();

    private DateUtil() {
    }

    public static Date getMinUnixDate() {
        return new Date(0L);
    }

    public static long currentUnixTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long date2UnixTimestamp(Date date) {
        return date.getTime() / 1000L;
    }

    public static Date UnixTimestamp2Date(long timestamp) {
        return new Date(timestamp * 1000L);
    }

    public static Date getCurrentDate() {
        Calendar today = Calendar.getInstance();
        today.set(today.get(1), today.get(2), today.get(5), 0, 0, 0);
        Date date = new Date();
        date.setTime(today.getTimeInMillis() / 1000L * 1000L);
        return date;
    }

    public static String getToday() {
        return DateUtil.getDayStr(new Date());
    }

    public static String getYesterday() {
        return DateUtil.getDayStr(DateUtil.getDayDiff(-1));
    }

    public static Date getFirstDate(Date date) {
        Calendar today = Calendar.getInstance();
        today.setTime(date);
        today.set(today.get(1), today.get(2), 1, 0, 0, 0);
        date.setTime(today.getTimeInMillis() / 1000L * 1000L);
        return date;
    }

    public static Date getNextMonthFirstDate(Date date) {
        Calendar today = Calendar.getInstance();
        today.setTime(date);
        today.set(today.get(1), today.get(2) + 1, 1, 0, 0, 0);
        date.setTime(today.getTimeInMillis() / 1000L * 1000L);
        return date;
    }

    public static String getChineseWeekDay(Date date) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        return chineseWeekDayMap.get(cl.get(7));
    }

    public static Integer getWeekDay(Date date) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        return cl.get(7) - 1;
    }

    public static Date getLastHourDate() {
        Calendar today = Calendar.getInstance();
        today.set(10, today.get(10) - 1);
        return today.getTime();
    }

    public static Date getDayDiff(int diff) {
        Calendar today = Calendar.getInstance();
        today.set(today.get(1), today.get(2), today.get(5) + diff, 0, 0, 0);
        return today.getTime();
    }

    public static Date getDiffDateTime(Date date, int diff) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, diff);
        return calendar.getTime();
    }

    public static Date getDiffDateTime(Date date, int diff, int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, diff);
        return calendar.getTime();
    }

    public static boolean whetherInTheAm(Date date) {
        GregorianCalendar ca = new GregorianCalendar();
        ca.setTime(date);
        return ca.get(9) == 0;
    }

    public static boolean isToday(Date date) {
        Calendar today = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return today.get(1) == calendar.get(1) && today.get(2) == calendar.get(2) && today.get(5) == calendar.get(5);
    }

    public static int getThisYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static int getThisMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1;
    }

    public static String getDayStr(Date date) {
        return DateUtil.getStrByDateFormate(date, "yyyyMMdd");
    }

    public static String getAllDayStr(Date date) {
        return DateUtil.getStrByDateFormate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(11));
    }

    public static String getMin(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(12));
    }

    public static String getSec(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(13));
    }

    public static Date getDateByDay(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day);
        return calendar.getTime();
    }

    public static Date getDateByYearMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, calendar.getMinimum(5), 0, 0, 0);
        return calendar.getTime();
    }

    public static Date endDateByYearMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        int value = calendar.getActualMaximum(5);
        calendar.set(5, value);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getDateByYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, 0, calendar.getMinimum(5), 0, 0, 0);
        return calendar.getTime();
    }

    public static Date endDateByYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, 11);
        int value = calendar.getActualMaximum(5);
        calendar.set(5, value);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static int getMonthDiff(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        return (c2.get(1) - c1.get(1)) * 12 + (c2.get(2) - c1.get(2));
    }

    public static int getDateDiff(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        long time1 = c1.getTimeInMillis();
        long time2 = c2.getTimeInMillis();
        long days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(days));
    }

    public static int getMinuteDiff(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        long time1 = c1.getTimeInMillis();
        long time2 = c2.getTimeInMillis();
        long minutes = (time2 - time1) / 60000L;
        return Integer.parseInt(String.valueOf(minutes));
    }

    public static Date getStrToDate(String format, String str) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.applyPattern(format);
        try {
            return simpleDateFormat.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDateByStr(String date) {
        return DateUtil.getStrToDate("yyyy-MM-dd", date);
    }

    public static String getStrByDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat("yyyy-MM-dd");
        String str = dateformat1.format(date);
        return str;
    }

    public static String getHourStrByDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat("HH:mm:ss");
        String str = dateformat1.format(date);
        return str;
    }

    public static String getMonthStrByDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat("yyyy-MM");
        String str = dateformat1.format(date);
        return str;
    }

    public static String getStrByDateFormate(Date date, String formate) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat(formate);
        String str = dateformat1.format(date);
        return str;
    }

    public static Date getOffSetDate(Date date, int offSet) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(5, offSet);
        return cal.getTime();
    }

    public static Date getOffSetDate(int offSet) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, offSet);
        return cal.getTime();
    }

    public static int dateCompare(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        start.set(start.get(1), start.get(2), start.get(5), 0, 0, 0);
        end.set(end.get(1), end.get(2), end.get(5), 0, 0, 0);
        long startTime = start.getTimeInMillis() / 1000L;
        long endTime = end.getTimeInMillis() / 1000L;
        if (startTime < endTime) {
            return 1;
        }
        if (startTime > endTime) {
            return -1;
        }
        return 0;
    }

    public static List<Date> getDateBetween(Date startDate, Date endDate) {
        Date date;
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        start.set(start.get(1), start.get(2), start.get(5), 0, 0, 0);
        end.set(end.get(1), end.get(2), end.get(5), 0, 0, 0);
        Calendar current = start;
        while (DateUtil.dateCompare(current.getTime(), end.getTime()) > 0) {
            date = new Date();
            date.setTime(current.getTimeInMillis() / 1000L * 1000L);
            dates.add(date);
            current.add(5, 1);
        }
        date = new Date();
        date.setTime(current.getTimeInMillis() / 1000L * 1000L);
        dates.add(date);
        current.add(5, 1);
        return dates;
    }

    public static Date getStartOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getStartOfDayAccurateToMillSeconde(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayByHour(Date date, int hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static String getCurrentYM() {
        Date date = new Date();
        SimpleDateFormat dateformat1 = new SimpleDateFormat("yyyyMM");
        String str = dateformat1.format(date);
        return str;
    }

    public static Date getStartOfWeek() {
        LocalDate now = new LocalDate();
        LocalDate time = now.dayOfWeek().withMinimumValue();
        return DateUtil.getStartOfDay(time.toDate());
    }

    public static Date getEndOfWeek() {
        LocalDate now = new LocalDate();
        LocalDate time = now.dayOfWeek().withMaximumValue();
        return DateUtil.getEndOfDay(time.toDate());
    }

    public static Date getStartOfMonth() {
        LocalDate now = new LocalDate();
        LocalDate time = now.dayOfMonth().withMinimumValue();
        return DateUtil.getStartOfDay(time.toDate());
    }

    public static Date getEndOfMonth() {
        LocalDate now = new LocalDate();
        LocalDate time = now.dayOfMonth().withMaximumValue();
        return DateUtil.getEndOfDay(time.toDate());
    }

    public static boolean compare(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        start.set(start.get(1), start.get(2), start.get(5), start.get(10), start.get(12), start.get(13));
        end.set(end.get(1), end.get(2), end.get(5), start.get(10), start.get(12), start.get(13));
        long startTime = start.getTimeInMillis();
        long endTime = end.getTimeInMillis();
        return startTime < endTime;
    }

    public static String getPayTime(Date date) {
        if (DateUtil.getStrByDate(date).equals(DateUtil.getStrByDate(new Date()))) {
            return DateUtil.getStrByDateFormate(date, "HH:mm");
        }
        return DateUtil.getStrByDateFormate(date, "MM-dd");
    }

    public static void main(String[] args) throws Exception {
        String string = DateUtil.getAllDayStr(new Date());
        System.out.println(string);
        System.out.println(DateUtil.endDateByYearMonth(2015, 11));
        System.out.println(new Date(1465949100000L));
        System.out.println(new Date(1465951800000L));
        System.out.println(DateUtil.getDayDiff(1));
        System.out.println(DateUtil.getDayDiff(0));
        System.out.println(DateUtil.getDayDiff(-2));
        System.out.println(DateUtil.getLastHourDate());
        System.out.println(DateUtil.getLastHourDate());
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTime(date);
        calendar.set(2015, 12, 30, 0, 2);
        System.out.println(calendar.getTime());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date testWeekDay = sdf.parse("2015-12-30");
        System.out.println("weekday= " + testWeekDay + "" + DateUtil.getWeekDay(testWeekDay));
        calendar.set(10, calendar.get(10) - 1);
        System.out.println(calendar.getTime());
        System.out.println(DateUtil.getLastHourDate());
        System.out.println(new Date().getTime());
        System.out.println(DateUtil.getFirstDate(date));
        System.out.println(DateUtil.getNextMonthFirstDate(date));
        System.out.println(DateUtil.getMonthDiff(new Date(), DateUtil.getDateByYearMonth(2015, 1)));
        System.out.println(new Date(1451923200000L));
        System.out.println(DateUtil.getStartOfDay(new Date()));
        System.out.println(DateUtil.getEndOfDay(new Date()));
        String html = "\u7b80\u4ecb\u63cf\u8ff0\u6492\u6253\u7b97\u7684\u7684\u6492\u7684\u6492\u7684\u6492\u7684\u6492\u7684\u6492\u7684\u98d2\u98d2\u5927<div>\u7684\u98d2\u98d2\u5927\u5927\u7231\u4e0a\u7684</div><div>\u6253\u7b97\u7684\u6492\u7684\u6492\u7231\u4e0a\u7684</div><div>\u5927\u58f0\u8bf4\u5927\u963f\u8428\u5fb7\u7684\u6492\u7684\u6492\u65e6\u6492\u5012\u8428\u5927</div><div>\u7684\u6492\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a</div><div>\u7684\u6492\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a</div><div>\u7684\u6492\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a\u554a</div>";
        HtmlUtils.htmlEscape((String)html);
    }

    static {
        chineseWeekDayMap.put(2, "\u4e00");
        chineseWeekDayMap.put(3, "\u4e8c");
        chineseWeekDayMap.put(4, "\u4e09");
        chineseWeekDayMap.put(5, "\u56db");
        chineseWeekDayMap.put(6, "\u4e94");
        chineseWeekDayMap.put(7, "\u516d");
        chineseWeekDayMap.put(1, "\u65e5");
    }
}

