/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericsUtils {
    private static final Logger log = LoggerFactory.getLogger(GenericsUtils.class);

    public static boolean notNullAndEmpty(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return ((String)obj).length() != 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() != 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).size() != 0;
        }
        Class<?> cla = obj.getClass();
        if (cla.isArray()) {
            return Array.getLength(obj) != 0;
        }
        return true;
    }

    public static boolean isNullOrEmpty(Object obj) {
        return !GenericsUtils.notNullAndEmpty(obj);
    }

    public static boolean isNotNull(Field field, Object qm) throws IllegalArgumentException, IllegalAccessException {
        boolean notNull = true;
        Class<?> type = field.getType();
        if (type == Integer.TYPE) {
            boolean bl = notNull = (Integer)field.get(qm) != 0;
        }
        if (type == Double.TYPE) {
            boolean bl = notNull = (Double)field.get(qm) != 0.0;
        }
        if (type == Float.TYPE) {
            boolean bl = notNull = (double)((Float)field.get(qm)).floatValue() != 0.0;
        }
        if (type == Boolean.TYPE) {
            boolean bl = notNull = (Boolean)field.get(qm) != false;
        }
        if (type == Character.TYPE) {
            boolean bl = notNull = ((Character)field.get(qm)).charValue() != '\u0000';
        }
        if (type == Byte.TYPE) {
            boolean bl = notNull = (Byte)field.get(qm) != 0;
        }
        if (type == Short.TYPE) {
            notNull = (Short)field.get(qm) != 0;
        }
        return notNull;
    }

    public static boolean notEqualsIn(String value, boolean ignoreCase, String ... strs) {
        boolean isIn = false;
        for (int i = 0; i < strs.length; ++i) {
            isIn = ignoreCase ? strs[i].equals(value) : strs[i].equalsIgnoreCase(value);
        }
        return isIn;
    }

    public static int indexOfIgnoreCase(String str, int fromIndex) {
        str = str.toLowerCase();
        return str.indexOf(str, fromIndex);
    }

    public static StringBuilder deleteLastChar(StringBuilder sb) {
        if (sb != null && sb.length() > 0) {
            return sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public static String deleteLastCharToString(StringBuilder sb) {
        return GenericsUtils.deleteLastChar(sb).toString();
    }

    public static <T extends Collection<K>, K> List<K> toList(T cols) {
        return new ArrayList(cols);
    }

    public static <T extends Collection<V>, K, V> Map<K, V> toKeyMap(T cols, String keyName, final Class<K> keyClass) {
        if (cols.isEmpty()) {
            return Collections.emptyMap();
        }
        Class<?> beanClass = cols.toArray()[0].getClass();
        try {
            List<String> keyList = Arrays.asList(keyName.split(","));
            final List<PropertyDescriptor> pdList = GenericsUtils.createPropertyDescriptorList(keyList, beanClass);
            Map retMap = CollectionUtils.extractMap(cols, (CollectionUtils.Extracter)new CollectionUtils.Extracter<K, V>(){
                Map<String, Object> keyValues = new HashMap<String, Object>();

                public K extract(V paramE) {
                    try {
                        for (PropertyDescriptor pd : pdList) {
                            Object value = pd.getReadMethod().invoke(paramE, new Object[0]);
                            this.keyValues.put(pd.getName(), value);
                        }
                        if (keyClass == String.class) {
                            ArrayList values = Lists.newArrayList(this.keyValues.values());
                            StringBuilder sb = new StringBuilder();
                            for (Object obj : values) {
                                sb.append(obj.toString()).append("_");
                            }
                            return GenericsUtils.deleteLastCharToString(sb);
                        }
                        Object keyInstanct = keyClass.newInstance();
                        BeanUtils.populate(keyInstanct, this.keyValues);
                        return keyInstanct;
                    }
                    catch (Exception e) {
                        log.debug("encount a error cause by : {} ", (Throwable)e);
                        return null;
                    }
                }
            });
            return retMap;
        }
        catch (IntrospectionException e) {
            log.error("exception : {} ", (Throwable)e);
            return null;
        }
    }

    private static List<PropertyDescriptor> createPropertyDescriptorList(List<String> keyList, Class<?> beanClass) throws IntrospectionException {
        ArrayList pds = Lists.newArrayListWithCapacity((int)keyList.size());
        for (String keyName : keyList) {
            PropertyDescriptor pd = new PropertyDescriptor(keyName, beanClass);
            pds.add(pd);
        }
        return pds;
    }

    public static <K, V> List<K> toKeyList(Collection<? extends V> cols, String field) {
        if (GenericsUtils.isNullOrEmpty(cols)) {
            return Collections.emptyList();
        }
        ArrayList<Object> retList = new ArrayList<Object>();
        try {
            Class<?> beanClass = cols.toArray()[0].getClass();
            PropertyDescriptor pd = new PropertyDescriptor(field, beanClass);
            for (V value : cols) {
                try {
                    retList.add(pd.getReadMethod().invoke(value, new Object[0]));
                }
                catch (Exception e) {
                    log.debug("encount a error cause by : {} ", (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            log.error("exception : {} ", (Throwable)ex);
        }
        return retList;
    }

    public static void setAccessable(String fieldName, Class<?> beanClass) {
        try {
            Field field = beanClass.getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
        }
        catch (Exception e) {
            log.debug("can not set accessible for field : {} in class : {} ", (Object)fieldName, beanClass);
        }
    }

    public static <T> List<T> emptyList() {
        return Lists.newArrayListWithCapacity((int)0);
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Maps.newHashMapWithExpectedSize((int)0);
    }

    public static <T> Set<T> emptySet() {
        return Sets.newHashSetWithExpectedSize((int)0);
    }

    public static <K, V> void addListIfNotExists(Map<K, List<V>> map, K key, V listValue) {
        ArrayList list = map.get(key);
        if (GenericsUtils.isNullOrEmpty(list)) {
            list = Lists.newArrayList();
            map.put(key, list);
        }
        list.add(listValue);
    }
}

