/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.filter;

import com.baijia.tianxiao.dto.mobile.AppAuthToken;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

public class WrapOrgTokenFilter
implements Filter {
    private static final String DEFAULTCOOKIENAME = "ORG_AUTH_TOKEN";
    private static final String DEFAULTPARAMNAME = "auth_token";
    private static final String DEFAULTPROPNAME = "passport-client.properties";
    private static final String DEFAULTVALIDTOKENURL = "valid.token.url";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String cookieName = "ORG_AUTH_TOKEN";
    private String paramName = "auth_token";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        String encryptedToken = this.retrieveCookieValue(servletRequest);
        if (StringUtils.isNotBlank((CharSequence)encryptedToken)) {
            this.initTianxiaoContext(encryptedToken);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("initTianxiaoContext from cookie");
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("can't find token in cookie. try find by request param");
            }
            if (StringUtils.isNotBlank((CharSequence)(encryptedToken = servletRequest.getParameter(this.paramName)))) {
                this.initTianxiaoContext(encryptedToken);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("initTianxiaoContext from request");
                }
            }
        }
        chain.doFilter(request, response);
        this.clearTianxiaoContext();
    }

    public void destroy() {
    }

    protected String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    private void initTianxiaoContext(String encryptedToken) {
        try {
            AppAuthToken token = JacksonUtil.str2Obj(EncryptUtils.strDecode(encryptedToken), AppAuthToken.class);
            TianxiaoMContext.setOrgId(token.getUser_id().intValue());
            TianxiaoMContext.setOrgCascadeId(token.getCascade_user_id());
            TianxiaoMContext.setOrgCascadeAuth(token.getAuth());
            TianxiaoMContext.setTXCascadeId(token.getTx_cascade_user_id());
            TianxiaoMContext.setTXLoginAccountId(token.getTx_account_id());
            TianxiaoMContext.setAppAuthToken(token);
        }
        catch (Exception e) {
            this.logger.warn("decode token error! encryptedToken is :" + encryptedToken, (Throwable)e);
        }
    }

    private String retrieveCookieValue(HttpServletRequest request) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
        if (this.logger.isDebugEnabled()) {
            this.logger.info("get token from cookie | cookieName:{}, cookie value:{}", (Object)this.getCookieName(), (Object)(cookie == null ? null : cookie.getValue()));
        }
        return cookie == null ? null : cookie.getValue();
    }

    private void clearTianxiaoContext() {
        TianxiaoMContext.clear();
    }
}

