/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.tianxiao.constants.SmsGateGroup;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.util.http.GSXService;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsSendUtil {
    private static final Logger log = LoggerFactory.getLogger(SmsSendUtil.class);

    public static boolean sendSms(String mobile, String content, Integer messageType, Integer userId, Integer userRole, boolean directSend, Integer smsGate) {
        if (smsGate != null && smsGate == -1) {
            return false;
        }
        RestfulResult<Object> response = SmsSendUtil.send(mobile, content, messageType, userId, userRole, directSend, smsGate);
        return response != null && response.getCode() == 0;
    }

    public static RestfulResult<Object> send(String mobile, String content, Integer messageType, Integer userId, Integer userRole, boolean directSend, Integer smsGate) {
        RestfulResult<Object> response = null;
        try {
            String controller = "sms";
            String action = "send";
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("mobile", mobile.replaceAll(" ", "").replace("-", ""));
            Preconditions.checkArgument((boolean)ParamValidateUtils.validateMobile((String)params.get("mobile")), (Object)("mobile :" + mobile + " is invalidate."));
            params.put("content", content);
            params.put("message_type", String.valueOf(messageType));
            if (userId != null) {
                params.put("user_id", String.valueOf(userId));
            }
            if (userRole != null) {
                params.put("role", String.valueOf(userRole));
            }
            if (directSend) {
                params.put("direct_send", "1");
            }
            if (smsGate != null) {
                params.put("gateway", smsGate.toString());
            } else {
                params.put("gateway", SmsGateGroup.DEFAULT_SMS_GATE.toString());
            }
            log.info("send sms to mobile:{},params:{}", (Object)mobile, params);
            response = GSXService.doService(controller, action, params);
            log.info("params:{}, response:{}", params, response);
        }
        catch (Exception e) {
            response = new RestfulResult<Object>();
            response.setCode(1);
            response.setData(null);
            response.setMsg("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25");
            log.error("sendSms exception - ", (Throwable)e);
        }
        return response;
    }

    public static boolean sendSms(String mobile, String content, Integer messageType, Integer userId, Integer userRole, Integer smsGate) {
        if (smsGate != null && smsGate == -1) {
            return false;
        }
        return SmsSendUtil.sendSms(mobile, content, messageType, userId, userRole, true, smsGate);
    }

    public static void main(String[] args) {
        Integer userId = 489661;
    }
}

