/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.constants.sms;

import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum TxSmsCodeType {
    APPLY(1, "\u7533\u8bf7\u8bd5\u7528\u5929\u6821", "\u9a8c\u8bc1\u7801{{code}}\uff08\u7533\u8bf7\u8bd5\u7528\u5929\u6821\uff09\uff0c\u8bf7\u6ce8\u610f\u4fdd\u5bc6\u5e76\u53ca\u65f6\u586b\u5199\u3002\u611f\u8c22\u60a8\u5bf9\u5929\u6821\u7684\u652f\u6301\uff0c\u54a8\u8be2\u7535\u8bdd4000-910-910\u3002", RedisKeyEnums.WWW.TX_APPLY_KEY.getRedisKey()),
    SAVE_PAY_PWD(2, "\u8bbe\u7f6e\u652f\u4ed8\u5bc6\u7801", "\u9a8c\u8bc1\u7801{{code}}(\u8bbe\u7f6e\u652f\u4ed8\u5bc6\u7801)\uff0c\u8bf7\u6ce8\u610f\u4fdd\u5bc6\u5e76\u53ca\u65f6\u586b\u5199\u3002\u611f\u8c22\u60a8\u5bf9\u5929\u6821\u7684\u652f\u6301\uff0c\u54a8\u8be2\u7535\u8bdd4000-910-910\u3002", RedisKeyEnums.CW.TX_SAVE_PAY_PWD_KEY.getRedisKey()),
    INVITE_TOBE_CAMPUS(3, "\u9080\u8bf7\u4e3a\u5206\u6821\u533a", "\u9a8c\u8bc1\u7801{{code}}(\u5206\u6821\u533a)\uff0c\u8bf7\u6ce8\u610f\u4fdd\u5bc6\u5e76\u53ca\u65f6\u586b\u5199\u3002\u611f\u8c22\u60a8\u5bf9\u5929\u6821\u7684\u652f\u6301\uff0c\u54a8\u8be2\u7535\u8bdd4000-910-910\u3002", RedisKeyEnums.CRM.TX_INVITE_TOBE_CAMPUS_KEY.getRedisKey()),
    MOD_ORG_MOBILE(4, "\u4fee\u6539\u4e3b\u8d26\u6237\u624b\u673a\u53f7", "\u9a8c\u8bc1\u7801{{code}}(\u4fee\u6539\u624b\u673a\u53f7\u7801)\uff0c\u8bf7\u6ce8\u610f\u4fdd\u5bc6\u5e76\u53ca\u65f6\u586b\u5199\u3002\u611f\u8c22\u60a8\u5bf9\u5929\u6821\u7684\u652f\u6301\uff0c\u54a8\u8be2\u7535\u8bdd4000-910-910\u3002", RedisKeyEnums.CRM.TX_MOD_ORG_MOBILE_KEY.getRedisKey()),
    NEW_ORG_PWD(4, "\u6d45\u6ce8\u518c\u5bc6\u7801\u77ed\u4fe1", "\u5bc6\u7801{{code}}\uff0c\u8bf7\u6ce8\u610f\u4fdd\u5bc6\u5e76\u53ca\u65f6\u4fee\u6539\u3002\u611f\u8c22\u60a8\u5bf9\u5929\u6821\u7684\u652f\u6301\uff0c\u54a8\u8be2\u7535\u8bdd4000-910-910\u3002", RedisKeyEnums.CRM.TX_NEW_ORG_PWD_KEY.getRedisKey()),
    NEW_CASCADE_PWD(4, " \u9080\u8bf7\u4e3a\u5b50\u5e10\u53f7", "\u5bc6\u7801{{code}}\uff0c\u8bf7\u6ce8\u610f\u4fdd\u5bc6\u5e76\u53ca\u65f6\u4fee\u6539\u3002\u611f\u8c22\u60a8\u5bf9\u5929\u6821\u7684\u652f\u6301\uff0c\u54a8\u8be2\u7535\u8bdd4000-910-910\u3002", RedisKeyEnums.CRM.TX_NEW_ORG_PWD_KEY.getRedisKey()),
    VZHIBO_CONSULT_MOBILE_KEY(5, "\u5fae\u76f4\u64ad\u53d1\u8a00\uff0c\u9a8c\u8bc1\u624b\u673a\u53f7", "\u9a8c\u8bc1\u7801{{code}}\uff0c\u8bf7\u6ce8\u610f\u4fdd\u5bc6\u5e76\u53ca\u65f6\u4fee\u6539\u3002\u611f\u8c22\u60a8\u5bf9\u5929\u6821\u7684\u652f\u6301\uff0c\u54a8\u8be2\u7535\u8bdd4000-910-910\u3002", RedisKeyEnums.VZB.VZHIBO_CONSULT_MOBILE_KEY.getRedisKey());

    private Integer code;
    private String label;
    private String msg;
    private String cacheKey;
    private static Map<String, TxSmsCodeType> noLogin;

    private TxSmsCodeType(Integer code, String label, String msg, String cacheKey) {
        this.code = code;
        this.label = label;
        this.msg = msg;
        this.cacheKey = cacheKey;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public static boolean isTypeValid(String type) {
        boolean result = false;
        if (StringUtils.isNotBlank((String)type)) {
            for (TxSmsCodeType codeType : TxSmsCodeType.values()) {
                if (!codeType.getCode().toString().equals(type)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static TxSmsCodeType getTxSmsCodeType(String type) {
        TxSmsCodeType smsCodeType = null;
        if (StringUtils.isNotBlank((String)type)) {
            for (TxSmsCodeType codeType : TxSmsCodeType.values()) {
                if (!codeType.getCode().toString().equals(type)) continue;
                smsCodeType = codeType;
                break;
            }
        }
        return smsCodeType;
    }

    public static String getSmsMsg(TxSmsCodeType codeType, String code) {
        return codeType.msg.replace("{{code}}", code);
    }

    public static boolean noLogin(String type) {
        return noLogin.containsKey(type);
    }

    static {
        noLogin = Maps.newHashMap();
        noLogin.put(TxSmsCodeType.APPLY.code.toString(), APPLY);
        noLogin.put(TxSmsCodeType.VZHIBO_CONSULT_MOBILE_KEY.code.toString(), VZHIBO_CONSULT_MOBILE_KEY);
    }
}

