/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.common.service;

import com.baijia.tianxiao.constants.DataProcType;
import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public interface ImportDataProcessService {
    public DataProcType getProcessType();

    public boolean validateHeader(List<String> var1);

    public boolean validateHeader(List<String> var1, Long var2);

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public SingleSaveErrorResult saveSingleData(Long var1, Long var2, List<String> var3, Object[] var4, boolean var5);

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public BatchSaveResult batchImportDatas(Long var1, Long var2, List<String> var3, List<Object[]> var4, boolean var5);

    public void afterComplete();

    public int[] getUniqueIndex();

    public SingleSaveErrorResult validate(Long var1, Long var2, List<String> var3, SingleSaveErrorResult var4, List<SingleSaveErrorResult> var5, boolean var6);

    public void downloadValidateResult(OutputStream var1, Long var2, String var3, Collection<SingleSaveErrorResult> var4);

    public void downloadImportResult(OutputStream var1, Long var2, String var3, Collection<SingleSaveErrorResult> var4);

    public void downloadImportTemplate(OutputStream var1);

    public String validateResult(List<SingleSaveErrorResult> var1);

    public static class SingleSaveErrorResult {
        private Object[] lineData;
        private boolean isRepeat;
        private String errorMsg;
        private Exception exception;
        private boolean isSuccess;
        private boolean isPublicClue = false;

        public SingleSaveErrorResult() {
        }

        public SingleSaveErrorResult(Object[] lineData) {
            this.lineData = lineData;
        }

        public SingleSaveErrorResult(boolean isRepeat, String errorMsg) {
            this.isRepeat = isRepeat;
            this.errorMsg = errorMsg;
        }

        public SingleSaveErrorResult(boolean isRepeat, Exception exception) {
            this.isRepeat = isRepeat;
            this.exception = exception;
        }

        public static SingleSaveErrorResult createSuccessResult(String msg) {
            SingleSaveErrorResult result = new SingleSaveErrorResult(false, msg);
            result.setSuccess(true);
            return result;
        }

        public static SingleSaveErrorResult createSuccessResult(String msg, boolean isPublicClue) {
            SingleSaveErrorResult result = new SingleSaveErrorResult(false, msg);
            result.setSuccess(true);
            result.setPublicClue(isPublicClue);
            return result;
        }

        public static SingleSaveErrorResult createFailResult(String msg) {
            SingleSaveErrorResult result = new SingleSaveErrorResult(false, msg);
            result.setSuccess(false);
            return result;
        }

        public Object[] getLineData() {
            return this.lineData;
        }

        public boolean isRepeat() {
            return this.isRepeat;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public boolean isPublicClue() {
            return this.isPublicClue;
        }

        public void setLineData(Object[] lineData) {
            this.lineData = lineData;
        }

        public void setRepeat(boolean isRepeat) {
            this.isRepeat = isRepeat;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public void setSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
        }

        public void setPublicClue(boolean isPublicClue) {
            this.isPublicClue = isPublicClue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleSaveErrorResult)) {
                return false;
            }
            SingleSaveErrorResult other = (SingleSaveErrorResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getLineData(), other.getLineData())) {
                return false;
            }
            if (this.isRepeat() != other.isRepeat()) {
                return false;
            }
            String this$errorMsg = this.getErrorMsg();
            String other$errorMsg = other.getErrorMsg();
            if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
                return false;
            }
            Exception this$exception = this.getException();
            Exception other$exception = other.getException();
            if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            return this.isPublicClue() == other.isPublicClue();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SingleSaveErrorResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getLineData());
            result = result * 59 + (this.isRepeat() ? 79 : 97);
            String $errorMsg = this.getErrorMsg();
            result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
            Exception $exception = this.getException();
            result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            result = result * 59 + (this.isPublicClue() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ImportDataProcessService.SingleSaveErrorResult(lineData=" + Arrays.deepToString(this.getLineData()) + ", isRepeat=" + this.isRepeat() + ", errorMsg=" + this.getErrorMsg() + ", exception=" + this.getException() + ", isSuccess=" + this.isSuccess() + ", isPublicClue=" + this.isPublicClue() + ")";
        }
    }

    public static class BatchSaveResult {
        private List<Integer> failIndexs = Lists.newArrayList();
        private List<Integer> repeatIndexs = Lists.newArrayList();

        public List<Integer> getFailIndexs() {
            return this.failIndexs;
        }

        public List<Integer> getRepeatIndexs() {
            return this.repeatIndexs;
        }

        public void setFailIndexs(List<Integer> failIndexs) {
            this.failIndexs = failIndexs;
        }

        public void setRepeatIndexs(List<Integer> repeatIndexs) {
            this.repeatIndexs = repeatIndexs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchSaveResult)) {
                return false;
            }
            BatchSaveResult other = (BatchSaveResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Integer> this$failIndexs = this.getFailIndexs();
            List<Integer> other$failIndexs = other.getFailIndexs();
            if (this$failIndexs == null ? other$failIndexs != null : !((Object)this$failIndexs).equals(other$failIndexs)) {
                return false;
            }
            List<Integer> this$repeatIndexs = this.getRepeatIndexs();
            List<Integer> other$repeatIndexs = other.getRepeatIndexs();
            return !(this$repeatIndexs == null ? other$repeatIndexs != null : !((Object)this$repeatIndexs).equals(other$repeatIndexs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BatchSaveResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Integer> $failIndexs = this.getFailIndexs();
            result = result * 59 + ($failIndexs == null ? 43 : ((Object)$failIndexs).hashCode());
            List<Integer> $repeatIndexs = this.getRepeatIndexs();
            result = result * 59 + ($repeatIndexs == null ? 43 : ((Object)$repeatIndexs).hashCode());
            return result;
        }

        public String toString() {
            return "ImportDataProcessService.BatchSaveResult(failIndexs=" + this.getFailIndexs() + ", repeatIndexs=" + this.getRepeatIndexs() + ")";
        }
    }
}

