/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CourseSmsTokenUtil {
    private static final Logger log = LoggerFactory.getLogger(CourseSmsTokenUtil.class);
    public static final int TOKEN_VERSION = 1;

    public static String encodeToken(Map<String, Object> params) throws Exception {
        return CourseSmsTokenUtil.encodeToken(params, (Long)params.get("orgId"));
    }

    public static String encodeToken(Map<String, Object> params, Long orgId) throws Exception {
        return CourseSmsTokenUtil.encodeExpireToken(params, orgId, DateUtil.getDiffDateTime(new Date(), 2));
    }

    public static String encodeExpireToken(Map<String, Object> params, Long orgId, Date expireDate) throws Exception {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        SmsToken token = new SmsToken();
        token.setOrgId(orgId);
        token.getParams().putAll(params);
        token.setTs(expireDate);
        token.setVersion(1);
        return EncryptUtils.base64EncodeStrWithFactor(token);
    }

    public static SmsToken decodeToken(String token) throws Exception {
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        String jsonStr = EncryptUtils.strDecode(token);
        try {
            return JacksonUtil.str2Obj(jsonStr, SmsToken.class);
        }
        catch (Exception e) {
            log.warn("decode token error! token:{}, jsonStr:{}, e:{}", new Object[]{token, jsonStr, e});
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println(CourseSmsTokenUtil.encodeToken(Maps.newHashMap(), 3618L));
        String token = "BoEoenkoQDg7Pjo5Oz86Pj9BPjk1K3h7cFNuLEQ-OjxBNy17bH5teX8uRogvfH90VnIwSEI-P0U7MYZ0cnhxhFGAgFp1M0sziIpCdEV3S0RMSUV5SkhFR0ZENpJBN4t6h4l_hYQ4UEiU";
        SmsToken t = CourseSmsTokenUtil.decodeToken(token);
        System.out.println(t);
        String token1 = "C34ld3YlPTQ3OjY7Nzg9NDY0ODkwJnN3bE5pJz85PTo1MSh2Z3hnc3koQIEodnluUGspQTs_PDc0Kn9ta3BpfEl4eFJtK0MrgIE5azxuQztDQDxwQT47PTw7LYg3LYFwfX50enouRj2J";
        SmsToken t1 = CourseSmsTokenUtil.decodeToken(token1);
        System.out.println(t1);
    }

    public static class SmsToken {
        private Date ts;
        private Long orgId;
        private Map<String, Object> params = new HashMap<String, Object>();
        private Integer version;

        public void put(String key, Object value) {
            this.params.put(key, value);
        }

        public Date getTs() {
            return this.ts;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Integer getVersion() {
            return this.version;
        }

        public void setTs(Date ts) {
            this.ts = ts;
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SmsToken)) {
                return false;
            }
            SmsToken other = (SmsToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Date this$ts = this.getTs();
            Date other$ts = other.getTs();
            if (this$ts == null ? other$ts != null : !((Object)this$ts).equals(other$ts)) {
                return false;
            }
            Long this$orgId = this.getOrgId();
            Long other$orgId = other.getOrgId();
            if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
                return false;
            }
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                return false;
            }
            Integer this$version = this.getVersion();
            Integer other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SmsToken;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Date $ts = this.getTs();
            result = result * 59 + ($ts == null ? 43 : ((Object)$ts).hashCode());
            Long $orgId = this.getOrgId();
            result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            Integer $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            return result;
        }

        public String toString() {
            return "CourseSmsTokenUtil.SmsToken(ts=" + this.getTs() + ", orgId=" + this.getOrgId() + ", params=" + this.getParams() + ", version=" + this.getVersion() + ")";
        }
    }
}

