/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.upload;

import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtils.class);

    public static UploadResult.UploadFile uploadToRemote(Long uid, File file, boolean watermark) {
        List<UploadResult.UploadFile> files;
        UploadResult uploadResult = FileUploadUtils.upload(uid, file, watermark);
        UploadResult.UploadFile uploadFile = null;
        if (uploadResult != null && (files = uploadResult.getFiles()) != null && !files.isEmpty()) {
            uploadFile = uploadResult.getFiles().get(0);
        }
        log.info("upload file result:{} and get first upload file:{}", (Object)uploadResult, uploadFile);
        return uploadFile;
    }

    public static UploadResult upload(Long uid, File file, boolean watermark) {
        long start = System.currentTimeMillis();
        Properties prop = PropertiesReader.getProperties("upload.properties");
        HashMap files = Maps.newHashMap();
        HashMap params = Maps.newHashMap();
        files.put("upfile", file);
        params.put("uid", prop.getProperty("upload.uid.prefix", "tianxiao_") + uid);
        String url = prop.getProperty("upload.server");
        if (watermark) {
            url = url + "?watermark=1";
        }
        String response = HttpClientUtils.doPostFiles(url, params, files);
        log.debug("doUpload - uid:{}, file:{}, response:{}", new Object[]{uid, file, response});
        long end = System.currentTimeMillis();
        log.info("UploadService.uploadToRemote: uid:{},cost:{}", (Object)uid, (Object)(end - start));
        return FileUploadUtils.parseResponse(response);
    }

    public static UploadResult uploadFiles(Long uid, Map<String, File> files, boolean watermark) {
        long start = System.currentTimeMillis();
        Properties prop = PropertiesReader.getProperties("upload.properties");
        HashMap params = Maps.newHashMap();
        params.put("uid", prop.getProperty("upload.uid.prefix", "tianxiao_") + uid);
        String url = prop.getProperty("upload.server");
        if (watermark) {
            url = url + "?watermark=1";
        }
        String response = HttpClientUtils.doPostFiles(url, params, files);
        log.debug("doUpload - uid:{}, file:{}, response:{}", new Object[]{uid, files, response});
        long end = System.currentTimeMillis();
        log.info("UploadService.uploadToRemote: uid:{},cost:{}", (Object)uid, (Object)(end - start));
        return FileUploadUtils.parseResponse(response);
    }

    public static UploadResult uploadToRemote(String uploadServerHost, String uid, File file, boolean watermark) {
        long start = System.currentTimeMillis();
        HashMap files = Maps.newHashMap();
        HashMap params = Maps.newHashMap();
        files.put("upfile", file);
        params.put("uid", uid);
        if (watermark) {
            uploadServerHost = uploadServerHost + "?watermark=1";
        }
        String response = HttpClientUtils.doPostFiles(uploadServerHost, params, files);
        log.debug("doUpload - uid:{}, file:{}, response:{}", new Object[]{uid, file, response});
        long end = System.currentTimeMillis();
        log.info("UploadService.uploadToRemote: uid:{},cost:{}", (Object)uid, (Object)(end - start));
        return FileUploadUtils.parseResponse(response);
    }

    public static UploadResult parseResponse(String response) {
        if (StringUtils.isBlank((CharSequence)response)) {
            return null;
        }
        UploadResult uploadResult = (UploadResult)new Gson().fromJson(response, UploadResult.class);
        return uploadResult;
    }

    public static UploadResult.UploadFile parseResponseFile(UploadResult uploadResult) {
        List<UploadResult.UploadFile> files;
        UploadResult.UploadFile uploadFile = null;
        if (uploadResult != null && (files = uploadResult.getFiles()) != null && !files.isEmpty()) {
            uploadFile = uploadResult.getFiles().get(0);
        }
        log.info("parseResponse - response:{}, uploadResult:{}", (Object)uploadResult, uploadFile);
        return uploadFile;
    }
}

