/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.tianxiao.beanCopy.BeanInvokeUtils;
import com.baijia.tianxiao.beanCopy.BeanMethodInvoke;
import com.baijia.tianxiao.beanCopy.Invoker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericsUtils {
    private static final Logger log = LoggerFactory.getLogger(GenericsUtils.class);
    private static final String COMMON_SPLIT_RETEX = "[,|:&#]+";

    public static boolean notNullAndEmpty(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return ((String)obj).length() != 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() != 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).size() != 0;
        }
        if (obj instanceof StringBuilder) {
            return ((StringBuilder)obj).length() != 0;
        }
        if (obj instanceof StringBuffer) {
            return ((StringBuffer)obj).length() != 0;
        }
        Class<?> cla = obj.getClass();
        if (cla.isArray()) {
            return Array.getLength(obj) != 0;
        }
        return true;
    }

    public static boolean isNullOrEmpty(Object obj) {
        return !GenericsUtils.notNullAndEmpty(obj);
    }

    public static boolean isNotNull(Field field, Object qm) throws IllegalArgumentException, IllegalAccessException {
        boolean notNull = true;
        Class<?> type = field.getType();
        if (type == Integer.TYPE) {
            notNull = (Integer)field.get(qm) != 0;
        } else if (type == Double.TYPE) {
            notNull = (Double)field.get(qm) != 0.0;
        } else if (type == Float.TYPE) {
            notNull = (double)((Float)field.get(qm)).floatValue() != 0.0;
        } else if (type == Boolean.TYPE) {
            notNull = (Boolean)field.get(qm) != false;
        } else if (type == Character.TYPE) {
            notNull = ((Character)field.get(qm)).charValue() != '\u0000';
        } else if (type == Byte.TYPE) {
            notNull = (Byte)field.get(qm) != 0;
        } else if (type == Short.TYPE) {
            notNull = (Short)field.get(qm) != 0;
        }
        return notNull;
    }

    public static boolean isNullOrDefaultValue(Object valueObj, String fieldName, Object ... defaultValue) throws IllegalArgumentException, IllegalAccessException {
        boolean isNullOrDefaultValue = true;
        Object defaultFieldValue = GenericsUtils.isNullOrEmpty(defaultValue) ? null : defaultValue[0];
        Invoker<Object> fieldReaderInvoker = GenericsUtils.getFieldReaderInvoker(fieldName, null, valueObj);
        Object fieldValue = fieldReaderInvoker.invoke(valueObj, new Object[0]);
        if (fieldValue == null) {
            return true;
        }
        Class<?> fieldType = fieldValue.getClass();
        if (defaultFieldValue != null && fieldValue.equals(defaultFieldValue)) {
            isNullOrDefaultValue = true;
        } else if (fieldType == Integer.TYPE) {
            isNullOrDefaultValue = (Integer)fieldValue == 0;
        } else if (fieldType == Double.TYPE) {
            isNullOrDefaultValue = (Double)fieldValue == 0.0;
        } else if (fieldType == Float.TYPE) {
            isNullOrDefaultValue = (double)((Float)fieldValue).floatValue() == 0.0;
        } else if (fieldType == Boolean.TYPE) {
            isNullOrDefaultValue = (Boolean)fieldValue == false;
        } else if (fieldType == Character.TYPE) {
            isNullOrDefaultValue = ((Character)fieldValue).charValue() == '\u0000';
        } else if (fieldType == Byte.TYPE) {
            isNullOrDefaultValue = (Byte)fieldValue == 0;
        } else if (fieldType == Short.TYPE) {
            isNullOrDefaultValue = (Short)fieldValue == 0;
        }
        return isNullOrDefaultValue;
    }

    public static boolean notEqualsIn(String value, boolean ignoreCase, String ... strs) {
        boolean isIn = false;
        for (int i = 0; i < strs.length; ++i) {
            isIn = ignoreCase ? strs[i].equals(value) : strs[i].equalsIgnoreCase(value);
        }
        return isIn;
    }

    public static int indexOfIgnoreCase(String str, int fromIndex) {
        str = str.toLowerCase();
        return str.indexOf(str, fromIndex);
    }

    public static StringBuilder deleteLastChar(StringBuilder sb) {
        if (sb != null && sb.length() > 0) {
            return sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public static String deleteLastCharToString(StringBuilder sb) {
        return GenericsUtils.deleteLastChar(sb).toString();
    }

    public static <T extends Collection<K>, K> List<K> toList(T cols) {
        return new ArrayList(cols);
    }

    public static <K, V> List<K> toFieldList(Collection<V> cols, String fieldName) {
        if (GenericsUtils.isNullOrEmpty(cols) || GenericsUtils.isNullOrEmpty(fieldName)) {
            return GenericsUtils.emptyList();
        }
        Iterator<V> iter = cols.iterator();
        ArrayList<Object> retList = new ArrayList<Object>(cols.size());
        Invoker<?> fieldReader = null;
        while (iter.hasNext()) {
            V next = iter.next();
            if (fieldReader == null) {
                BeanMethodInvoke<?> findBeanMethodInovker = BeanInvokeUtils.findBeanMethodInovker(next.getClass());
                fieldReader = findBeanMethodInovker.getFieldReader(fieldName);
            }
            Object invoke = fieldReader.invoke(next, new Object[0]);
            retList.add(invoke);
        }
        return retList;
    }

    public static <T extends Collection<V>, V, K, R> Map<K, R> toFieldMap(T cols, String ... keyNames) {
        if (GenericsUtils.isNullOrEmpty(cols) || GenericsUtils.isNullOrEmpty(keyNames)) {
            log.debug("cols is null:{} or field is null :{} ", (Object)GenericsUtils.isNullOrEmpty(cols), (Object)GenericsUtils.isNullOrEmpty(keyNames));
            return GenericsUtils.emptyMap();
        }
        String keyOfKey = keyNames[0];
        String keyOfValue = null;
        if (keyNames.length >= 2) {
            keyOfValue = keyNames[1];
        }
        Iterator<V> iter = cols.iterator();
        HashMap<Object, Object> retMap = new HashMap<Object, Object>(cols.size());
        Invoker<V> fieldReaderForKey = null;
        Invoker<V> fieldReaderForValue = null;
        while (iter.hasNext()) {
            V next = iter.next();
            fieldReaderForKey = GenericsUtils.getFieldReaderInvoker(keyOfKey, fieldReaderForKey, next);
            Object key = fieldReaderForKey.invoke(next, new Object[0]);
            Object value = null;
            value = keyOfValue != null ? GenericsUtils.getFieldReaderInvoker(keyOfValue, fieldReaderForValue, next).invoke(next, new Object[0]) : (Object)next;
            retMap.put(key, value);
        }
        return retMap;
    }

    public static <T extends Collection<V>, V, K, R> Map<K, List<R>> toFieldListMap(T cols, String ... keyNames) {
        if (GenericsUtils.isNullOrEmpty(cols) || GenericsUtils.isNullOrEmpty(keyNames)) {
            log.debug("cols is null:{} or field is null :{} ", (Object)GenericsUtils.isNullOrEmpty(cols), (Object)GenericsUtils.isNullOrEmpty(keyNames));
            return GenericsUtils.emptyMap();
        }
        String keyOfKey = keyNames[0];
        String keyOfValue = null;
        if (keyNames.length >= 2) {
            keyOfValue = keyNames[1];
        }
        Iterator<V> iter = cols.iterator();
        HashMap retMap = new HashMap(cols.size());
        Invoker<V> fieldReaderForKey = null;
        Invoker<V> fieldReaderForValue = null;
        while (iter.hasNext()) {
            V next = iter.next();
            fieldReaderForKey = GenericsUtils.getFieldReaderInvoker(keyOfKey, fieldReaderForKey, next);
            Object key = fieldReaderForKey.invoke(next, new Object[0]);
            Object value = null;
            value = keyOfValue != null ? GenericsUtils.getFieldReaderInvoker(keyOfValue, fieldReaderForValue, next).invoke(next, new Object[0]) : (Object)next;
            GenericsUtils.addListIfNotExists(retMap, key, value);
        }
        return retMap;
    }

    public static <V> Invoker<V> getFieldReaderInvoker(String keyOfKey, Invoker<V> fieldReader, V next) {
        if (fieldReader == null) {
            BeanMethodInvoke<?> findBeanMethodInovker = BeanInvokeUtils.findBeanMethodInovker(next.getClass());
            fieldReader = findBeanMethodInovker.getFieldReader(keyOfKey);
        }
        return fieldReader;
    }

    @Deprecated
    public static <K, V> List<K> toKeyList(Collection<? extends V> cols, String field) {
        return GenericsUtils.toFieldList(cols, field);
    }

    public static void setAccessable(String fieldName, Class<?> beanClass) {
        try {
            Field field = beanClass.getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
        }
        catch (Exception e) {
            log.debug("can not set accessible for field : {} in class : {} ", (Object)fieldName, beanClass);
        }
    }

    public static <T> List<T> emptyList() {
        return Lists.newArrayListWithCapacity((int)0);
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Maps.newHashMapWithExpectedSize((int)0);
    }

    public static <T> Set<T> emptySet() {
        return Sets.newHashSetWithExpectedSize((int)0);
    }

    public static <K, V> void addListIfNotExists(Map<K, List<V>> map, K key, V listValue) {
        List<V> list = map.get(key);
        if (GenericsUtils.isNullOrEmpty(list)) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(listValue);
    }

    public static <T> Set<T> stringToNumber(String numStr, Class<T> numType) {
        return GenericsUtils.stringToNumber(numStr, COMMON_SPLIT_RETEX, numType);
    }

    public static <T> Set<T> stringToNumber(String numStr, String splitRegex, Class<T> numType) {
        if (GenericsUtils.isNullOrEmpty(numStr)) {
            return GenericsUtils.emptySet();
        }
        String[] allValues = numStr.split(splitRegex);
        HashSet retSet = Sets.newHashSet();
        for (String value : allValues) {
            T numValue = GenericsUtils.getNumValueFromStr(numType, value);
            retSet.add(numValue);
        }
        return retSet;
    }

    public static <T> List<T> stringToNumberList(String numStr, String splitRegex, Class<T> numType) {
        if (GenericsUtils.isNullOrEmpty(numStr)) {
            return GenericsUtils.emptyList();
        }
        String[] allValues = numStr.split(splitRegex);
        ArrayList retList = Lists.newArrayList();
        for (String value : allValues) {
            T numValue = GenericsUtils.getNumValueFromStr(numType, value);
            retList.add(numValue);
        }
        return retList;
    }

    public static <T> T getNumValueFromStr(Class<T> numType, String value) {
        Constable numValue = null;
        if (numType == Integer.class || numType == Integer.TYPE) {
            numValue = Integer.parseInt(value);
        } else if (numType == Float.class || numType == Float.TYPE) {
            numValue = Float.valueOf(Float.parseFloat(value));
        } else if (numType == Short.class || numType == Short.TYPE) {
            numValue = Short.parseShort(value);
        } else if (numType == Long.class || numType == Long.TYPE) {
            numValue = Long.parseLong(value);
        } else if (numType == Double.class || numType == Double.TYPE) {
            numValue = Double.parseDouble(value);
        } else if (numType == Byte.class || numType == Byte.TYPE) {
            numValue = Byte.parseByte(value);
        } else if (numType == Character.class || numType == Character.TYPE) {
            numValue = new Character(value.charAt(0));
        }
        return (T)numValue;
    }

    public static void logErrorAndInfo(Logger logger, Exception ex, String format, Object ... infos) {
        if (GenericsUtils.notNullAndEmpty(format)) {
            format = format.replace("{}", "%s");
            logger.info("[Pring Error Info ] {} ", (Object)String.format(format, infos));
        }
        logger.error("[exception] {} ", (Throwable)ex);
    }

    public static void logErrorAndInfo(Class<?> clazz, Exception ex, String format, Object ... infos) {
        Logger log = LoggerFactory.getLogger(clazz);
        GenericsUtils.logErrorAndInfo(log, ex, format, infos);
    }

    public static String formatOutput(String format, Object ... params) {
        if (GenericsUtils.isNullOrEmpty(params) || GenericsUtils.isNullOrEmpty(format)) {
            return format;
        }
        if (format.contains("{}")) {
            format = format.replace("{}", "%s");
        }
        return String.format(format, params);
    }

    public static Map<Object, Object> groupSortForRetMap(Collection<Object> list, List<Comparator> comparators) {
        if (GenericsUtils.isNullOrEmpty(list) || GenericsUtils.isNullOrEmpty(comparators)) {
            throw new IllegalArgumentException("illegal arguments");
        }
        LinkedHashMap retMap = Maps.newLinkedHashMap();
        HashMap tempMap = Maps.newHashMap();
        Comparator groupSortComparator = comparators.remove(0);
        HashSet keys = Sets.newHashSet();
        boolean isSortWithMulit = false;
        if (groupSortComparator instanceof MulitGroupSortComparator) {
            isSortWithMulit = true;
        }
        for (Object obj : list) {
            Object pid = null;
            if (groupSortComparator instanceof comparatorSuper) {
                pid = ((comparatorSuper)((Object)groupSortComparator)).getPid(obj);
            }
            keys.add(pid);
            if (isSortWithMulit) {
                pid = ((MulitGroupSortComparator)groupSortComparator).getPid(obj).getPid();
            }
            GenericsUtils.addListIfNotExists(tempMap, pid, obj);
        }
        ArrayList keyReplace = Lists.newArrayList((Iterable)keys);
        Collections.sort(keyReplace, groupSortComparator);
        for (Object key : keyReplace) {
            List remove;
            if (isSortWithMulit) {
                key = ((MulitGroupSorter)key).getPid();
            }
            if (GenericsUtils.isNullOrEmpty(remove = (List)tempMap.remove(key))) continue;
            if (GenericsUtils.isNullOrEmpty(comparators)) {
                retMap.put(key, remove);
                continue;
            }
            ArrayList comparatorList = Lists.newArrayList(comparators);
            retMap.put(key, GenericsUtils.groupSortForRetMap(remove, comparatorList));
        }
        return retMap;
    }

    public static <T> List<T> groupSort(Collection<Object> list, List<Comparator> comparators) {
        Map<Object, Object> groupSortForRetMap = GenericsUtils.groupSortForRetMap(list, comparators);
        System.out.println("groupSortForRetMap is : " + groupSortForRetMap);
        List<T> retList = GenericsUtils.findFromMap(groupSortForRetMap);
        return retList;
    }

    private static <T> List<T> findFromMap(Map<Object, Object> groupSortForRetMap) {
        ArrayList retList = Lists.newArrayList();
        for (Map.Entry<Object, Object> entry : groupSortForRetMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                retList.addAll(GenericsUtils.findFromMap((Map)value));
                continue;
            }
            if (!(value instanceof Collection)) continue;
            for (Object val : (Collection)value) {
                retList.add(val);
            }
        }
        return retList;
    }

    public static void main(String[] args) {
        ArrayList<Object> users = new ArrayList<Object>();
        for (int i = 0; i < 10; ++i) {
            User user = null;
            user = i % 2 == 0 ? new User("Pary ", "paryAge" + i, (int)(Math.random() * 10.0)) : new User("Rezar", "rezarAge" + i, (int)(Math.random() * 10.0));
            users.add(user);
        }
        GroupSortComparator<String, User> comparators = new GroupSortComparator<String, User>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }

            @Override
            public String getPid(User obj) {
                return obj.getName();
            }
        };
        GroupSortComparator<Integer, User> comparators2 = new GroupSortComparator<Integer, User>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }

            @Override
            public Integer getPid(User obj) {
                return obj.getType();
            }
        };
        ArrayList lists = Lists.newArrayList();
        lists.add(comparators);
        lists.add(comparators2);
        List<User> groupSort = GenericsUtils.groupSort(users, lists);
        for (User user : groupSort) {
            System.out.println("name:" + user.getName() + " -- type:" + user.getType());
        }
    }

    public static void testMethod() {
        System.out.println(GenericsUtils.formatOutput("i am :{} and i love banlangen", "Rezar"));
        List<Long> userIds = Arrays.asList(445678L);
        System.out.println(GenericsUtils.isNullOrEmpty(userIds));
    }

    public static <T> T getNullWithoutError(Map<String, Object> options, String key) {
        if (GenericsUtils.isNullOrEmpty(options) || GenericsUtils.isNullOrEmpty(key)) {
            return null;
        }
        Object object = options.get(key);
        if (object == null) {
            return null;
        }
        try {
            return (T)object;
        }
        catch (Exception e) {
            log.info("error while cast object:{} with class:{} ", object, (Object)object.getClass().getName());
            return null;
        }
    }

    public static class User {
        private String name;
        private String age;
        private Integer type;

        public User(String name, String age, Integer type) {
            this.name = name;
            this.age = age;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getAge() {
            return this.age;
        }

        public Integer getType() {
            return this.type;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAge(String age) {
            this.age = age;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof User)) {
                return false;
            }
            User other = (User)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$age = this.getAge();
            String other$age = other.getAge();
            if (this$age == null ? other$age != null : !this$age.equals(other$age)) {
                return false;
            }
            Integer this$type = this.getType();
            Integer other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof User;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $age = this.getAge();
            result = result * 59 + ($age == null ? 43 : $age.hashCode());
            Integer $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            return result;
        }

        public String toString() {
            return "GenericsUtils.User(name=" + this.getName() + ", age=" + this.getAge() + ", type=" + this.getType() + ")";
        }
    }

    public static abstract class MulitGroupSorter<T> {
        private T obj;

        public abstract Object getPid();

        public MulitGroupSorter(T obj2) {
            this.obj = obj2;
        }

        public T getObj() {
            return this.obj;
        }

        public void setObj(T obj) {
            this.obj = obj;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MulitGroupSorter)) {
                return false;
            }
            MulitGroupSorter other = (MulitGroupSorter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$obj = this.getObj();
            T other$obj = other.getObj();
            return !(this$obj == null ? other$obj != null : !this$obj.equals(other$obj));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MulitGroupSorter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $obj = this.getObj();
            result = result * 59 + ($obj == null ? 43 : $obj.hashCode());
            return result;
        }

        public String toString() {
            return "GenericsUtils.MulitGroupSorter(obj=" + this.getObj() + ")";
        }
    }

    public static interface MulitGroupSortComparator<T>
    extends Comparator<MulitGroupSorter<T>>,
    comparatorSuper<MulitGroupSorter<T>, T> {
        @Override
        public MulitGroupSorter<T> getPid(T var1);
    }

    public static interface GroupSortComparator<F, T>
    extends Comparator<F>,
    comparatorSuper<F, T> {
    }

    public static interface comparatorSuper<F, T> {
        public F getPid(T var1);
    }
}

