/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.beanCopy;

import com.baijia.tianxiao.beanCopy.DefaultFilter;
import com.baijia.tianxiao.beanCopy.FieldFilter;
import com.baijia.tianxiao.beanCopy.Invoker;
import com.baijia.tianxiao.beanCopy.InvokerCreateor;
import com.baijia.tianxiao.beanCopy.MethodFilter;
import com.baijia.tianxiao.beanCopy.SpecialNameRegistry;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.TupleUtil;
import com.baijia.tianxiao.util.TwoTuple;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanMethodInvoke<T> {
    private static final Logger log = LoggerFactory.getLogger(BeanMethodInvoke.class);
    private int hasCodeAsKey;
    private Class<?> hostClass;
    private String hostClassName;
    private static DefaultFilter defaultFilter = new DefaultFilter();
    private FieldFilter fieldFilter;
    private MethodFilter methodFilter;
    public static final Object[] EMPTY_ARGS = new Object[0];
    public static final List<String> exclude_methods = Arrays.asList("main([Ljava/lang/String;)V", "toString()Ljava/lang/String;", "equals(Ljava/lang/Object;)Z", "hashCode()I", "wait(JI)V", "wait(J)V", "wait()V", "getClass()Ljava/lang/Class;", "notify()V", "notifyAll()V");
    public List<String> fieldNames = new ArrayList<String>();
    private Map<String, Type> fieldTypeMapper = new HashMap<String, Type>();
    private Map<Integer, Invoker<T>> publicMethodInvoke = new HashMap<Integer, Invoker<T>>();

    public BeanMethodInvoke(Class<?> hostClass, FieldFilter fieldFilter, MethodFilter methodFilter) {
        if (hostClass == null) {
            return;
        }
        ClassLoader cl = hostClass.getClassLoader();
        log.debug("classLoader : {} ", (Object)cl);
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        String classLoaderDesc = org.objectweb.asm.Type.getDescriptor(cl.getClass());
        String classDesc = org.objectweb.asm.Type.getDescriptor(hostClass);
        this.hasCodeAsKey = Arrays.hashCode(new String[]{classLoaderDesc, classDesc});
        log.debug("className:{} with classLoad:{} , generate hashcode :{} ", new Object[]{classDesc, classLoaderDesc, this.hasCodeAsKey});
        this.hostClass = hostClass;
        this.hostClassName = this.hostClass.getName();
        this.fieldFilter = fieldFilter == null ? defaultFilter : fieldFilter;
        this.methodFilter = methodFilter == null ? defaultFilter : methodFilter;
        this.generatorMethodInvoke();
    }

    public BeanMethodInvoke(Class<?> hostClass) {
        this(hostClass, defaultFilter, defaultFilter);
    }

    public int getBeanKey() {
        return this.hasCodeAsKey;
    }

    public <R> R getInvokeResult(String keyName, Object ... args) {
        throw new UnsupportedOperationException("Has not been implemented");
    }

    private void generatorMethodInvoke() {
        Method[] methods = this.hostClass.getMethods();
        if (GenericsUtils.isNullOrEmpty(methods)) {
            return;
        }
        Map<String, TwoTuple<String, Boolean>> fieldVisitMethod = BeanMethodInvoke.getFieldVisitMethod(this.hostClass);
        Field[] fields = this.hostClass.getDeclaredFields();
        for (Field field : fields) {
            if (!this.fieldFilter.needFilter(field)) {
                this.fieldNames.add(field.getName());
            }
            this.fieldTypeMapper.put(field.getName(), field.getType());
        }
        for (AccessibleObject accessibleObject : methods) {
            boolean methodNeedFilter = this.methodFilter.needFilter((Method)accessibleObject);
            String methodDesc = org.objectweb.asm.Type.getMethodDescriptor((Method)accessibleObject);
            if (methodNeedFilter || exclude_methods.contains(((Method)accessibleObject).getName() + methodDesc)) continue;
            TwoTuple<String, Boolean> propertyDescriptor = fieldVisitMethod.get(((Method)accessibleObject).getName());
            if (propertyDescriptor != null) {
                log.debug(((Method)accessibleObject).getName() + "-----" + (String)propertyDescriptor.first);
                if (!this.fieldNames.contains(propertyDescriptor.first)) continue;
            }
            Integer fieldVisitKey = null;
            Integer methodId = SpecialNameRegistry.getInstance().getMethodIdAndAllocate(this.hostClassName, ((Method)accessibleObject).getName(), SpecialNameRegistry.argumentTypesToString(((Method)accessibleObject).getParameterTypes()));
            log.info("methodId is :{}", (Object)methodId);
            Invoker<T> invoker = this.createInvoker((Method)accessibleObject);
            if (propertyDescriptor != null && !this.publicMethodInvoke.containsKey(fieldVisitKey = (Boolean)propertyDescriptor.second != false ? Integer.valueOf(("R" + (String)propertyDescriptor.first).hashCode()) : Integer.valueOf(("W" + (String)propertyDescriptor.first).hashCode()))) {
                this.publicMethodInvoke.put(fieldVisitKey, invoker);
            }
            this.publicMethodInvoke.put(methodId, invoker);
        }
    }

    private Invoker<T> createInvoker(Method method) {
        log.debug("method is : " + method.getName());
        return InvokerCreateor.createInvoker(method);
    }

    public static Map<String, TwoTuple<String, Boolean>> getFieldVisitMethod(Class<?> sourceClass) {
        List<PropertyDescriptor> classPropertyDescriptors = BeanMethodInvoke.getClassPropertyDescriptors(sourceClass);
        HashMap<String, TwoTuple<String, Boolean>> ret = new HashMap<String, TwoTuple<String, Boolean>>();
        for (PropertyDescriptor pd : classPropertyDescriptors) {
            Method writeMethod;
            Method readMethod = pd.getReadMethod();
            if (readMethod != null) {
                ret.put(readMethod.getName(), TupleUtil.tuple(pd.getName(), true));
            }
            if ((writeMethod = pd.getWriteMethod()) == null) continue;
            ret.put(writeMethod.getName(), TupleUtil.tuple(pd.getName(), false));
        }
        return ret;
    }

    public static Map<String, PropertyDescriptor> getClassPropertyDescMap(Class<?> sourceClass, boolean isMethodName) {
        List<PropertyDescriptor> classPropertyDescriptors = BeanMethodInvoke.getClassPropertyDescriptors(sourceClass);
        HashMap<String, PropertyDescriptor> retMap = new HashMap<String, PropertyDescriptor>(classPropertyDescriptors.size());
        for (PropertyDescriptor pd : classPropertyDescriptors) {
            if (isMethodName) {
                retMap.put(pd.getReadMethod().getName(), pd);
                retMap.put(pd.getWriteMethod().getName(), pd);
                continue;
            }
            retMap.put(pd.getName(), pd);
        }
        return retMap;
    }

    public static List<PropertyDescriptor> getClassPropertyDescriptors(Class<?> sourceClass) {
        ArrayList<PropertyDescriptor> propertys = new ArrayList<PropertyDescriptor>();
        try {
            List<PropertyDescriptor> propertyTmp = Arrays.asList(Introspector.getBeanInfo(sourceClass).getPropertyDescriptors());
            for (PropertyDescriptor property : propertyTmp) {
                String name = property.getName();
                if ("class".equals(name)) continue;
                propertys.add(property);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return propertys;
    }

    public Invoker<T> getFieldReader(String fieldName) {
        int hashCodeFlag = ("R" + fieldName).hashCode();
        log.debug("R fieldVisitKey --- :" + hashCodeFlag);
        Invoker<T> invoker = this.publicMethodInvoke.get(hashCodeFlag);
        if (invoker == null) {
            throw new RuntimeException(String.format("can not find any write methoh for field : %s  , Maybe the field has been filtered or the field was not exists in class:%s", fieldName, this.hostClass.getName()));
        }
        return invoker;
    }

    public Invoker<T> getFieldWriter(String fieldName) {
        int hashCodeFlag = ("W" + fieldName).hashCode();
        log.debug("W fieldVisitKey --- :" + hashCodeFlag);
        Invoker<T> invoker = this.publicMethodInvoke.get(hashCodeFlag);
        if (invoker == null) {
            throw new RuntimeException(String.format("can not find any read methoh for field : %s  , Maybe the field has been filtered or the field was not exists in class:%s", fieldName, this.hostClass.getName()));
        }
        return invoker;
    }

    public Invoker<T> getMethodInvoker(String methodName, Class<?>[] paramTypes) {
        return this.publicMethodInvoke.get(SpecialNameRegistry.getInstance().getMethodIdAndAllocate(this.hostClassName, methodName, SpecialNameRegistry.argumentTypesToString(paramTypes)));
    }

    public void replaceInvoker(int flag, Invoker<T> invoker) {
        this.publicMethodInvoke.put(flag, invoker);
    }

    public Type getFieldType(String fieldName) {
        return this.fieldTypeMapper.get(fieldName);
    }

    public int getHasCodeAsKey() {
        return this.hasCodeAsKey;
    }

    public Class<?> getHostClass() {
        return this.hostClass;
    }

    public String getHostClassName() {
        return this.hostClassName;
    }

    public FieldFilter getFieldFilter() {
        return this.fieldFilter;
    }

    public MethodFilter getMethodFilter() {
        return this.methodFilter;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public Map<String, Type> getFieldTypeMapper() {
        return this.fieldTypeMapper;
    }

    public Map<Integer, Invoker<T>> getPublicMethodInvoke() {
        return this.publicMethodInvoke;
    }

    public void setHasCodeAsKey(int hasCodeAsKey) {
        this.hasCodeAsKey = hasCodeAsKey;
    }

    public void setHostClass(Class<?> hostClass) {
        this.hostClass = hostClass;
    }

    public void setHostClassName(String hostClassName) {
        this.hostClassName = hostClassName;
    }

    public void setFieldFilter(FieldFilter fieldFilter) {
        this.fieldFilter = fieldFilter;
    }

    public void setMethodFilter(MethodFilter methodFilter) {
        this.methodFilter = methodFilter;
    }

    public void setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public void setFieldTypeMapper(Map<String, Type> fieldTypeMapper) {
        this.fieldTypeMapper = fieldTypeMapper;
    }

    public void setPublicMethodInvoke(Map<Integer, Invoker<T>> publicMethodInvoke) {
        this.publicMethodInvoke = publicMethodInvoke;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeanMethodInvoke)) {
            return false;
        }
        BeanMethodInvoke other = (BeanMethodInvoke)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHasCodeAsKey() != other.getHasCodeAsKey()) {
            return false;
        }
        Class<?> this$hostClass = this.getHostClass();
        Class<?> other$hostClass = other.getHostClass();
        if (this$hostClass == null ? other$hostClass != null : !this$hostClass.equals(other$hostClass)) {
            return false;
        }
        String this$hostClassName = this.getHostClassName();
        String other$hostClassName = other.getHostClassName();
        if (this$hostClassName == null ? other$hostClassName != null : !this$hostClassName.equals(other$hostClassName)) {
            return false;
        }
        FieldFilter this$fieldFilter = this.getFieldFilter();
        FieldFilter other$fieldFilter = other.getFieldFilter();
        if (this$fieldFilter == null ? other$fieldFilter != null : !this$fieldFilter.equals(other$fieldFilter)) {
            return false;
        }
        MethodFilter this$methodFilter = this.getMethodFilter();
        MethodFilter other$methodFilter = other.getMethodFilter();
        if (this$methodFilter == null ? other$methodFilter != null : !this$methodFilter.equals(other$methodFilter)) {
            return false;
        }
        List<String> this$fieldNames = this.getFieldNames();
        List<String> other$fieldNames = other.getFieldNames();
        if (this$fieldNames == null ? other$fieldNames != null : !((Object)this$fieldNames).equals(other$fieldNames)) {
            return false;
        }
        Map<String, Type> this$fieldTypeMapper = this.getFieldTypeMapper();
        Map<String, Type> other$fieldTypeMapper = other.getFieldTypeMapper();
        if (this$fieldTypeMapper == null ? other$fieldTypeMapper != null : !((Object)this$fieldTypeMapper).equals(other$fieldTypeMapper)) {
            return false;
        }
        Map<Integer, Invoker<T>> this$publicMethodInvoke = this.getPublicMethodInvoke();
        Map<Integer, Invoker<T>> other$publicMethodInvoke = other.getPublicMethodInvoke();
        return !(this$publicMethodInvoke == null ? other$publicMethodInvoke != null : !((Object)this$publicMethodInvoke).equals(other$publicMethodInvoke));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BeanMethodInvoke;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHasCodeAsKey();
        Class<?> $hostClass = this.getHostClass();
        result = result * 59 + ($hostClass == null ? 43 : $hostClass.hashCode());
        String $hostClassName = this.getHostClassName();
        result = result * 59 + ($hostClassName == null ? 43 : $hostClassName.hashCode());
        FieldFilter $fieldFilter = this.getFieldFilter();
        result = result * 59 + ($fieldFilter == null ? 43 : $fieldFilter.hashCode());
        MethodFilter $methodFilter = this.getMethodFilter();
        result = result * 59 + ($methodFilter == null ? 43 : $methodFilter.hashCode());
        List<String> $fieldNames = this.getFieldNames();
        result = result * 59 + ($fieldNames == null ? 43 : ((Object)$fieldNames).hashCode());
        Map<String, Type> $fieldTypeMapper = this.getFieldTypeMapper();
        result = result * 59 + ($fieldTypeMapper == null ? 43 : ((Object)$fieldTypeMapper).hashCode());
        Map<Integer, Invoker<T>> $publicMethodInvoke = this.getPublicMethodInvoke();
        result = result * 59 + ($publicMethodInvoke == null ? 43 : ((Object)$publicMethodInvoke).hashCode());
        return result;
    }

    public String toString() {
        return "BeanMethodInvoke(hasCodeAsKey=" + this.getHasCodeAsKey() + ", hostClass=" + this.getHostClass() + ", hostClassName=" + this.getHostClassName() + ", fieldFilter=" + this.getFieldFilter() + ", methodFilter=" + this.getMethodFilter() + ", fieldNames=" + this.getFieldNames() + ", fieldTypeMapper=" + this.getFieldTypeMapper() + ", publicMethodInvoke=" + this.getPublicMethodInvoke() + ")";
    }
}

