/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.validation;

import com.baijia.tianxiao.dto.mobile.AppAuthToken;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateTokenUtil {
    private static final Logger log = LoggerFactory.getLogger(ValidateTokenUtil.class);
    public static Map<String, Integer> accountVersionMap = Maps.newConcurrentMap();
    public static final String CASCADE_PREFIX = "cascade_prefix_";
    public static final String ORG_ID_PREFIX = "orgid_prefix_";

    public static final boolean isTokenValid(AppAuthToken token) {
        boolean result = true;
        Integer txCascadeUserId = token.getTx_cascade_user_id();
        Integer orgId = token.getUser_id().intValue();
        Integer tokenVersion = token.getAccountVersion();
        log.debug("InnerSync token:{}", (Object)token);
        if (txCascadeUserId != null) {
            if (accountVersionMap.containsKey(CASCADE_PREFIX + txCascadeUserId)) {
                Integer dbVersion = accountVersionMap.get(CASCADE_PREFIX + txCascadeUserId);
                if (tokenVersion == null ? dbVersion > 0 : dbVersion > tokenVersion) {
                    return false;
                }
            }
        } else if (orgId != null && accountVersionMap.containsKey(ORG_ID_PREFIX + orgId)) {
            Integer dbVersion = accountVersionMap.get(ORG_ID_PREFIX + orgId);
            if (tokenVersion == null ? dbVersion > 0 : dbVersion > tokenVersion) {
                return false;
            }
        }
        return result;
    }
}

