/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.encrypt;

import com.baijia.tianxiao.beanCopy.BeanInvokeUtils;
import com.baijia.tianxiao.dto.WsSocket.SocketAuthToken;
import com.baijia.tianxiao.dto.mobile.AppAuthToken;
import com.baijia.tianxiao.dto.mobile.TxAuthToken;
import com.baijia.tianxiao.dto.push.PushTokenConfig;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.base.Splitter;
import com.google.common.io.BaseEncoding;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public final class EncryptUtils {
    private static final Charset charset = Charset.forName("CP437");
    private static byte[] DEF_KEY = "NP1=~0710*(kZV)M".getBytes();
    private static String DEF_CHARSET = "UTF-8";
    private static int SALT_LENGTH = 8;

    public static String encodeWithAES(String data) throws Exception {
        if (StringUtils.isBlank((String)data)) {
            return "";
        }
        byte[] dataBytes = data.getBytes(DEF_CHARSET);
        SecretKeySpec skey = new SecretKeySpec(DEF_KEY, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, skey);
        byte[] result = cipher.doFinal(dataBytes);
        return Base64.encodeBase64String((byte[])result);
    }

    public static String decodeWithAES(String data) throws Exception {
        byte[] dataBytes = Base64.decodeBase64((String)data);
        SecretKeySpec skey = new SecretKeySpec(DEF_KEY, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, skey);
        byte[] result = cipher.doFinal(dataBytes);
        return new String(result, DEF_CHARSET);
    }

    public static String strDecode(String token) {
        String src = EncryptUtils.base64Decode(token);
        char factor = src.charAt(0);
        int c = factor % 8;
        String entity = src.substring(1);
        List slice = Splitter.fixedLength((int)factor).splitToList((CharSequence)entity);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slice.size(); ++i) {
            byte[] chars = ((String)slice.get(i)).getBytes(charset);
            for (int j = 0; j < chars.length; ++j) {
                byte ch = chars[j];
                int t = ch - c - i;
                if (t < 0) {
                    t += 256;
                }
                sb.append((char)t);
            }
        }
        return sb.toString();
    }

    public static String base64Decode(String src) {
        if (StringUtils.isBlank((String)src)) {
            return "";
        }
        String deStr = src.replace('-', '+').replace('_', '/');
        return new String(BaseEncoding.base64().decode((CharSequence)deStr), charset);
    }

    public static String strEncode(Integer userId) throws Exception {
        String salt = PasswordUtil.randomStr(SALT_LENGTH);
        AppAuthToken appAuthToken = new AppAuthToken();
        appAuthToken.setCt((int)(System.currentTimeMillis() / 1000L));
        appAuthToken.setSalt(salt);
        appAuthToken.setUser_id((long)userId);
        String str = JacksonUtil.obj2Str(appAuthToken);
        return EncryptUtils.base64EncodeStrWithFactor(str);
    }

    public static String wsEncode(String bizType, String userId, Integer deviceDomain) throws Exception {
        String salt = PasswordUtil.randomStr(SALT_LENGTH);
        SocketAuthToken socketAuthToken = new SocketAuthToken();
        socketAuthToken.setCt((int)(System.currentTimeMillis() / 1000L));
        socketAuthToken.setSalt(salt);
        socketAuthToken.setUser_id(userId);
        socketAuthToken.setBiz_type(bizType);
        socketAuthToken.setDevice_domain(deviceDomain);
        String str = JacksonUtil.obj2Str(socketAuthToken);
        return EncryptUtils.base64EncodeStrWithFactor(str);
    }

    public static String pushTokenEncode(PushTokenConfig authToken) throws Exception {
        String salt = PasswordUtil.randomStr(SALT_LENGTH);
        authToken.setCt((int)(System.currentTimeMillis() / 1000L));
        authToken.setSalt(salt);
        String str = JacksonUtil.obj2Str(authToken);
        return EncryptUtils.base64EncodeStrWithFactor(str);
    }

    public static String base64EncodeStrWithFactor(Object obj) {
        return EncryptUtils.base64EncodeStrWithFactor(JacksonUtil.obj2Str(obj));
    }

    public static String base64EncodeStrWithFactor(String data) {
        Random random = new Random();
        int factor = random.nextInt((int)Math.min(255.0, Math.ceil(data.length() / 3))) + 1;
        int c = factor % 8;
        List slice = Splitter.fixedLength((int)factor).splitToList((CharSequence)data);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slice.size(); ++i) {
            byte[] chars = ((String)slice.get(i)).getBytes(charset);
            for (int j = 0; j < chars.length; ++j) {
                byte ch = chars[j];
                byte t = (byte)(ch + c + i);
                sb.append(new String(new byte[]{t}, charset));
            }
        }
        String token = EncryptUtils.base64Encode(factor, sb.toString());
        return token;
    }

    public static String strEncode(Integer userId, Long cascade_user_id, String auth, Integer ts) throws Exception {
        String salt = PasswordUtil.randomStr(SALT_LENGTH);
        AppAuthToken appAuthToken = new AppAuthToken();
        appAuthToken.setCt(ts);
        appAuthToken.setSalt(salt);
        appAuthToken.setUser_id((long)userId);
        String str = JacksonUtil.obj2Str(appAuthToken);
        return EncryptUtils.base64EncodeStrWithFactor(str);
    }

    public static String base64Encode(int factor, String src) {
        if (StringUtils.isBlank((String)src)) {
            return "";
        }
        src = (char)factor + src;
        String deStr = BaseEncoding.base64().encode(src.getBytes(charset));
        String result = deStr.replace('+', '-').replace('/', '_');
        while (result.endsWith("=")) {
            result = result.substring(0, result.length() - 1).toString();
        }
        return result;
    }

    public static String txStrEncode(Integer userId, Integer tx_cascade_user_id, Integer tx_account_id, Integer fromOrgId, Integer txVisitorId, Integer accountVersion, String appEnv) throws Exception {
        String salt = PasswordUtil.randomStr(SALT_LENGTH);
        TxAuthToken appAuthToken = new TxAuthToken();
        appAuthToken.setCt((int)(System.currentTimeMillis() / 1000L));
        appAuthToken.setSalt(salt);
        appAuthToken.setUser_id((long)userId);
        appAuthToken.setTx_cascade_user_id(tx_cascade_user_id);
        appAuthToken.setTx_account_id(tx_account_id);
        appAuthToken.setTXFrom_org_id(fromOrgId);
        appAuthToken.setAccountVersion(accountVersion);
        appAuthToken.setTx_visitor_id(txVisitorId);
        appAuthToken.setAppEnv(appEnv);
        String str = JacksonUtil.obj2Str(appAuthToken);
        Random random = new Random();
        int factor = random.nextInt((int)Math.min(255.0, Math.ceil(str.length() / 3))) + 1;
        int c = factor % 8;
        List slice = Splitter.fixedLength((int)factor).splitToList((CharSequence)str);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slice.size(); ++i) {
            byte[] chars = ((String)slice.get(i)).getBytes(charset);
            for (int j = 0; j < chars.length; ++j) {
                byte ch = chars[j];
                byte t = (byte)(ch + c + i);
                sb.append(new String(new byte[]{t}, charset));
            }
        }
        String token = EncryptUtils.base64Encode(factor, sb.toString());
        return token;
    }

    public static String txStrEncode(Integer userId, Integer tx_cascade_user_id, Integer tx_account_id, Integer fromOrgId, Integer accountVersion, String appEnv) throws Exception {
        return EncryptUtils.txStrEncode(userId, tx_cascade_user_id, tx_account_id, fromOrgId, null, accountVersion, appEnv);
    }

    public static String txStrEncode(Integer userId, Integer tx_cascade_user_id, Integer tx_account_id, Integer accountVersion, String appEnv) throws Exception {
        String salt = PasswordUtil.randomStr(SALT_LENGTH);
        TxAuthToken appAuthToken = new TxAuthToken();
        appAuthToken.setCt((int)(System.currentTimeMillis() / 1000L));
        appAuthToken.setSalt(salt);
        appAuthToken.setUser_id((long)userId);
        appAuthToken.setTx_cascade_user_id(tx_cascade_user_id);
        appAuthToken.setTx_account_id(tx_account_id);
        appAuthToken.setAccountVersion(accountVersion);
        appAuthToken.setAppEnv(appEnv);
        Map<String, Object> copyToMap = BeanInvokeUtils.transBean2Map(appAuthToken, "tx_from_org_id", "tx_visitor_id");
        String str = JacksonUtil.obj2Str(copyToMap);
        Random random = new Random();
        int factor = random.nextInt((int)Math.min(255.0, Math.ceil(str.length() / 3))) + 1;
        int c = factor % 8;
        List slice = Splitter.fixedLength((int)factor).splitToList((CharSequence)str);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slice.size(); ++i) {
            byte[] chars = ((String)slice.get(i)).getBytes(charset);
            for (int j = 0; j < chars.length; ++j) {
                byte ch = chars[j];
                byte t = (byte)(ch + c + i);
                sb.append(new String(new byte[]{t}, charset));
            }
        }
        String token = EncryptUtils.base64Encode(factor, sb.toString());
        return token;
    }

    public static void main(String[] args) throws Exception {
        String txStrEncode = EncryptUtils.txStrEncode(1234, 23, null, 2345, null, null, null);
        System.out.println(txStrEncode.length());
        String token1 = EncryptUtils.strEncode(52817);
        PushTokenConfig token = new PushTokenConfig();
        String str = EncryptUtils.pushTokenEncode(token);
        String result = EncryptUtils.txStrEncode(4995, null, null, 0, "test");
        System.out.println(result);
        String result1 = EncryptUtils.strDecode("D4IpfHpseWZwaylBOUA5PDQqa3wqQnZ9dHQ0KntpdH0rQytiOXh9UGKBdis1K21rfW1rbm9pf31vfGlzbi1FeYB3dzctbIB_cy1FeYF4eDgugIRrb21_b21wcWyCgHJ_bHZxL0dEQ0A5L4KGbW9xcX2DfIJtd3IwSH2Ee3uM");
        System.out.println(result1);
    }
}

