/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final BigDecimal MILLION = new BigDecimal("100000");
    private static final BigDecimal TEN_THOUSAND = new BigDecimal("10000");
    private static final BigDecimal BILLION = new BigDecimal("1000000000");

    public static boolean hanziAndLetterValidate(String str) {
        String regex = "[0-9a-zA-Z\u4e00-\u9fa5]*";
        return str.matches(regex);
    }

    public static boolean numberValidate(String str) {
        String regex = "^([0-9])+$";
        return str.matches(regex);
    }

    public static boolean letterValidate(String str) {
        String regex = "^([a-zA-Z])+$";
        return str.matches(regex);
    }

    public static String formatNumber(BigDecimal number) {
        if (number == null) {
            return "0.00";
        }
        if (number.compareTo(BILLION) >= 0) {
            return "99,999.9\u4e07+";
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setGroupingUsed(true);
        if (number.compareTo(MILLION) >= 0) {
            BigDecimal tmp = number.divide(TEN_THOUSAND, 1, 4);
            numberFormat.setMinimumFractionDigits(1);
            return numberFormat.format(tmp.doubleValue()) + "\u4e07";
        }
        return numberFormat.format(number.doubleValue());
    }

    public static String formatNumber(Number num, int scala) {
        if (num == null) {
            return "0.00";
        }
        BigDecimal number = new BigDecimal(num.doubleValue());
        if (number.compareTo(BILLION) >= 0) {
            return "99,999.9\u4e07+";
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        if (number.compareTo(MILLION) >= 0) {
            BigDecimal tmp = number.divide(TEN_THOUSAND, 1, 4);
            numberFormat.setMinimumFractionDigits(1);
            return numberFormat.format(tmp.doubleValue()) + "\u4e07";
        }
        numberFormat.setMinimumFractionDigits(scala);
        return numberFormat.format(number.doubleValue());
    }

    public static String delHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }

    public static String imgToHttps(String url) {
        if (url == null) {
            return "";
        }
        return url.replaceFirst("http://img.gsxservice.com", "https://imgs.genshuixue.com");
    }

    public static void main(String[] args) {
    }
}

