/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.image;

import com.google.common.base.Preconditions;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgQrImageUtils {
    private static final Logger log = LoggerFactory.getLogger(OrgQrImageUtils.class);
    private static final int DEFAULT_IMAGE_WIDTH = 880;
    private static final int DEFAULT_IMAGE_HEIGHT = 320;

    /*
     * Loose catch block
     */
    public static Image getImageFromUrl(String url) throws IOException {
        BufferedImage bufferedImage;
        InputStream in4Ex;
        block10: {
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{url}), (Object)"image url can not be null");
            URL imageUrl = new URL(url);
            InputStream in = null;
            in4Ex = null;
            try {
                in = imageUrl.openStream();
                bufferedImage = ImageIO.read(in);
                if (in == null) break block10;
            }
            catch (IIOException e) {
                BufferedImage bufferedImage2;
                block11: {
                    imageUrl = new URL("https://imgs.genshuixue.com/23036387_sfu8bjal.png");
                    in4Ex = imageUrl.openStream();
                    bufferedImage2 = ImageIO.read(in4Ex);
                    if (in == null) break block11;
                    IOUtils.closeQuietly((InputStream)in);
                }
                if (in4Ex != null) {
                    IOUtils.closeQuietly((InputStream)in4Ex);
                }
                return bufferedImage2;
            }
            catch (Exception e2) {
                log.error(url, (Throwable)e2);
                throw e2;
                {
                    catch (Throwable throwable) {
                        if (in != null) {
                            IOUtils.closeQuietly((InputStream)in);
                        }
                        if (in4Ex != null) {
                            IOUtils.closeQuietly(in4Ex);
                        }
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        if (in4Ex != null) {
            IOUtils.closeQuietly((InputStream)in4Ex);
        }
        return bufferedImage;
    }

    public static Image readImageFromFile(String fileName) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileName}), (Object)"image file name can not be null");
        File imgFile = new File(fileName);
        if (!imgFile.exists()) {
            throw new FileNotFoundException(fileName + " is not exist");
        }
        return ImageIO.read(imgFile);
    }

    public static Image loadImage(String fileName) throws IOException {
        BufferedImage bufferedImage;
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileName}), (Object)"image file name can not be null");
        InputStream in = null;
        try {
            in = OrgQrImageUtils.class.getClassLoader().getResourceAsStream(fileName);
            Preconditions.checkNotNull((Object)in, (Object)("can not read file:" + fileName));
            bufferedImage = ImageIO.read(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return bufferedImage;
    }

    public static void main(String[] args) throws IOException {
        BufferedImage img = OrgQrImageUtils.generateOrgQrFingerPrintImg("\u673a\u6784\u540d\u79f0", "http://test-img.gsxservice.com/429623_wvy1l1ie.jpg", "1234567 \u8f6c 666", "\u5fae\u8f6f\u96c5\u9ed1", "http://wx.qlogo.cn/mmopen/VHU8bI7BOJCOrCdj43nwWEibME0liaPg2sIf9hZ8SnTrttgbOJGOQiao3AHq6ZzATbk177IagO7HIWZwhBnHVib9YR7dibS3nmDLy/0");
        File file = new File("/Users/zhenyujian/Desktop/image.jpg");
        ImageIO.write((RenderedImage)img, "png", file);
    }

    public static BufferedImage generateOrgQrFingerPrintImg(String orgName, String qrUrl, String telStr, String weixin, String weixinHeadImgUrl) throws IOException {
        if (StringUtils.isBlank((CharSequence)weixinHeadImgUrl)) {
            weixinHeadImgUrl = "https://imgs.genshuixue.com/23036387_sfu8bjal.png";
        }
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgName}), (Object)"orgName can not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qrUrl}), (Object)"qrUrl can not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{weixin}), (Object)"weixin can not be null");
        Image qrImg = OrgQrImageUtils.getImageFromUrl(qrUrl);
        Image weixinHeadImg = OrgQrImageUtils.getImageFromUrl(weixinHeadImgUrl);
        String weixinStr = "\u516c\u4f17\u53f7 \uff1a" + weixin;
        telStr = "\u7535   \u8bdd \uff1a" + telStr;
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 20);
        BufferedImage bi = new BufferedImage(880, 320, 8);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setBackground(Color.WHITE);
        g2.fillRect(0, 0, 880, 320);
        g2.setPaint(Color.BLACK);
        g2.setFont(font);
        int x = 100;
        int y = 160;
        BufferedImage a = OrgQrImageUtils.makeRoundedCorner((BufferedImage)weixinHeadImg, 1000);
        g2.drawImage(a, 200, 40, 130, 130, null);
        g2.drawString(weixinStr, x, y / 2 + 129);
        g2.drawString(telStr, x, y / 2 + 160);
        g2.drawString("\u957f\u6309\u53f3\u4fa7\u4e8c\u7ef4\u7801 , \u5173\u6ce8\u6211\u4eec\u3002", x, y / 2 + 190);
        g2.drawImage(qrImg, 600 - x, 20, 280, 280, null);
        return bi;
    }

    public static BufferedImage setClip(BufferedImage srcImage, int radius) {
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D gs = image.createGraphics();
        gs.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gs.setClip(new RoundRectangle2D.Double(0.0, 0.0, width, height, radius, radius));
        gs.drawImage((Image)srcImage, 0, 0, null);
        gs.dispose();
        return image;
    }

    public static BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return output;
    }
}

