/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dto;

import com.baijia.tianxiao.annotation.Show;
import com.baijia.tianxiao.constants.FieldType;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FieldShow {
    private String name;
    private String poName;
    private String showName;
    private Integer lock;
    private String type;
    private Integer operate;
    private Integer viewType;

    public static List<FieldShow> getColumnShows(Class<?> cls) {
        Method[] methods;
        Field[] fields;
        Preconditions.checkArgument((cls != null ? 1 : 0) != 0, (Object)"cls is null!");
        ArrayList result = Lists.newArrayList();
        for (Field field : fields = cls.getDeclaredFields()) {
            Show show = field.getAnnotation(Show.class);
            if (show == null) continue;
            FieldShow fieldShow = new FieldShow();
            fieldShow.setName(field.getName());
            fieldShow.setShowName(show.name());
            fieldShow.setLock(show.lock());
            fieldShow.setType(FieldShow.getType(field));
            fieldShow.setViewType(show.viewType());
            fieldShow.setPoName(FieldShow.getPoName(field.getName(), show));
            fieldShow.setOperate(show.operate());
            result.add(fieldShow);
        }
        for (Method method : methods = cls.getDeclaredMethods()) {
            Show show = method.getAnnotation(Show.class);
            String name = FieldShow.getField(method.getName());
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name}) || show == null) continue;
            FieldShow fieldShow = new FieldShow();
            fieldShow.setName(name);
            fieldShow.setShowName(show.name());
            fieldShow.setLock(show.lock());
            fieldShow.setType(FieldShow.getType(method));
            fieldShow.setViewType(show.viewType());
            fieldShow.setPoName(FieldShow.getPoName(name, show));
            fieldShow.setOperate(show.operate());
            result.add(fieldShow);
        }
        return result;
    }

    private static String getType(Method method) {
        if (method.getReturnType() == String.class) {
            return FieldType.string.getMessage();
        }
        if (method.getReturnType() == Date.class) {
            return FieldType.date.getMessage();
        }
        return FieldType.number.getMessage();
    }

    private static String getType(Field field) {
        if (field.getType() == String.class) {
            return FieldType.string.getMessage();
        }
        if (field.getType() == Date.class) {
            return FieldType.date.getMessage();
        }
        return FieldType.number.getMessage();
    }

    private static String getPoName(String name, Show show) {
        if (StringUtils.isBlank((CharSequence)show.poName())) {
            return name;
        }
        return show.poName();
    }

    public static Map<String, FieldShow> getColumnShowMap(Class<?> cls) {
        Method[] methods;
        Field[] fields;
        Preconditions.checkArgument((cls != null ? 1 : 0) != 0, (Object)"cls is null!");
        HashMap map = Maps.newHashMap();
        for (Field field : fields = cls.getDeclaredFields()) {
            Show show = field.getAnnotation(Show.class);
            if (show == null) continue;
            FieldShow fieldShow = new FieldShow();
            fieldShow.setName(field.getName());
            fieldShow.setShowName(show.name());
            fieldShow.setLock(show.lock());
            fieldShow.setType(FieldShow.getType(field));
            fieldShow.setViewType(show.viewType());
            fieldShow.setPoName(FieldShow.getPoName(field.getName(), show));
            fieldShow.setOperate(show.operate());
            map.put(field.getName(), fieldShow);
        }
        for (Method method : methods = cls.getDeclaredMethods()) {
            Show show = method.getAnnotation(Show.class);
            String name = FieldShow.getField(method.getName());
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name}) || show == null) continue;
            FieldShow fieldShow = new FieldShow();
            fieldShow.setName(name);
            fieldShow.setShowName(show.name());
            fieldShow.setLock(show.lock());
            fieldShow.setType(FieldShow.getType(method));
            fieldShow.setViewType(show.viewType());
            fieldShow.setPoName(FieldShow.getPoName(name, show));
            fieldShow.setOperate(show.operate());
            map.put(name, fieldShow);
        }
        return map;
    }

    private static String getField(String methodName) {
        if (methodName.startsWith("get")) {
            char start = methodName.charAt(3);
            StringBuilder sb = new StringBuilder();
            sb.append(String.valueOf(start).toLowerCase());
            if (methodName.length() > 4) {
                sb.append(methodName.substring(4));
            }
            return sb.toString();
        }
        return null;
    }

    public static boolean isFieldsUsable(Class<?> cls, List<FieldShow> fields) {
        Map<String, FieldShow> fieldMap = FieldShow.getColumnShowMap(cls);
        for (FieldShow show : fields) {
            if (!fieldMap.containsKey(show.getName())) {
                return false;
            }
            FieldShow field = fieldMap.get(show.getName());
            show.setLock(field.getLock());
            show.setType(field.getType());
            show.setOperate(field.getOperate());
            show.setPoName(field.getPoName());
            show.setViewType(field.viewType);
        }
        Map<String, FieldShow> map = CollectorUtil.collectMap(fields, new Function<FieldShow, String>(){

            public String apply(FieldShow arg0) {
                return arg0.getName();
            }
        });
        for (FieldShow fieldShow : fieldMap.values()) {
            if (fieldShow.lock != 1 || map.containsKey(fieldShow.getName())) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getPoName() {
        return this.poName;
    }

    public String getShowName() {
        return this.showName;
    }

    public Integer getLock() {
        return this.lock;
    }

    public String getType() {
        return this.type;
    }

    public Integer getOperate() {
        return this.operate;
    }

    public Integer getViewType() {
        return this.viewType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPoName(String poName) {
        this.poName = poName;
    }

    public void setShowName(String showName) {
        this.showName = showName;
    }

    public void setLock(Integer lock) {
        this.lock = lock;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setOperate(Integer operate) {
        this.operate = operate;
    }

    public void setViewType(Integer viewType) {
        this.viewType = viewType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldShow)) {
            return false;
        }
        FieldShow other = (FieldShow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$poName = this.getPoName();
        String other$poName = other.getPoName();
        if (this$poName == null ? other$poName != null : !this$poName.equals(other$poName)) {
            return false;
        }
        String this$showName = this.getShowName();
        String other$showName = other.getShowName();
        if (this$showName == null ? other$showName != null : !this$showName.equals(other$showName)) {
            return false;
        }
        Integer this$lock = this.getLock();
        Integer other$lock = other.getLock();
        if (this$lock == null ? other$lock != null : !((Object)this$lock).equals(other$lock)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Integer this$operate = this.getOperate();
        Integer other$operate = other.getOperate();
        if (this$operate == null ? other$operate != null : !((Object)this$operate).equals(other$operate)) {
            return false;
        }
        Integer this$viewType = this.getViewType();
        Integer other$viewType = other.getViewType();
        return !(this$viewType == null ? other$viewType != null : !((Object)this$viewType).equals(other$viewType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FieldShow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $poName = this.getPoName();
        result = result * 59 + ($poName == null ? 43 : $poName.hashCode());
        String $showName = this.getShowName();
        result = result * 59 + ($showName == null ? 43 : $showName.hashCode());
        Integer $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : ((Object)$lock).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Integer $operate = this.getOperate();
        result = result * 59 + ($operate == null ? 43 : ((Object)$operate).hashCode());
        Integer $viewType = this.getViewType();
        result = result * 59 + ($viewType == null ? 43 : ((Object)$viewType).hashCode());
        return result;
    }

    public String toString() {
        return "FieldShow(name=" + this.getName() + ", poName=" + this.getPoName() + ", showName=" + this.getShowName() + ", lock=" + this.getLock() + ", type=" + this.getType() + ", operate=" + this.getOperate() + ", viewType=" + this.getViewType() + ")";
    }
}

