/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.beanCopy;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteSourceClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(ByteSourceClassLoader.class);
    private static ByteSourceClassLoader loader = new ByteSourceClassLoader();
    private static Map<ClassLoader, ByteSourceClassLoader> loaderCache = new HashMap<ClassLoader, ByteSourceClassLoader>();
    private static Lock lock = new ReentrantLock();
    private boolean userSuper;

    private ByteSourceClassLoader() {
    }

    public ByteSourceClassLoader(ClassLoader cl) {
        super(cl);
        this.userSuper = true;
    }

    public Class<?> defineClass(String className, byte[] clazzBuff) {
        Class<?> retClass = this.findLoadedClass(className);
        if (retClass != null) {
            return retClass;
        }
        if (this.userSuper) {
            return super.defineClass(className, clazzBuff, 0, clazzBuff.length);
        }
        return this.defineClass(className, clazzBuff, 0, clazzBuff.length);
    }

    public static Class<?> loadClass(String className, byte[] clazzBuff) {
        return loader.defineClass(className, clazzBuff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> loadClass(ClassLoader cl, String className, byte[] classBuff) {
        ByteSourceClassLoader bsc = loaderCache.get(cl);
        if (bsc == null) {
            lock.lock();
            try {
                bsc = loaderCache.get(cl);
                if (bsc == null) {
                    bsc = new ByteSourceClassLoader(cl);
                    loaderCache.put(cl, bsc);
                }
            }
            catch (Exception ex) {
                log.error("exception : {} ", (Throwable)ex);
            }
            finally {
                lock.unlock();
            }
        }
        if (bsc == null) {
            return null;
        }
        return bsc.defineClass(className, classBuff);
    }
}

