/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.excel.dto;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ExportField {
    private String name;
    private String format = "@";
    private String prop;
    private int width;
    private Object defaultVal;
    private List<ExportField> children;

    public int getWidth() {
        if (this.width == 0 && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.name})) {
            return this.name.length() * 256;
        }
        return this.width;
    }

    public int getExportFieldSize() {
        if (CollectionUtils.isEmpty(this.children)) {
            return 1;
        }
        int size = 0;
        for (ExportField child : this.children) {
            size += child.getExportFieldSize();
        }
        return size;
    }

    public ExportField() {
    }

    public ExportField(String name, String format, int width) {
        this.name = name;
        this.format = format;
        this.width = width;
    }

    public ExportField(String name, String format, int width, Object defaultVal) {
        this.name = name;
        this.format = format;
        this.width = width;
        this.defaultVal = defaultVal;
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public String getProp() {
        return this.prop;
    }

    public Object getDefaultVal() {
        return this.defaultVal;
    }

    public List<ExportField> getChildren() {
        return this.children;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setProp(String prop) {
        this.prop = prop;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setDefaultVal(Object defaultVal) {
        this.defaultVal = defaultVal;
    }

    public void setChildren(List<ExportField> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportField)) {
            return false;
        }
        ExportField other = (ExportField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$prop = this.getProp();
        String other$prop = other.getProp();
        if (this$prop == null ? other$prop != null : !this$prop.equals(other$prop)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        Object this$defaultVal = this.getDefaultVal();
        Object other$defaultVal = other.getDefaultVal();
        if (this$defaultVal == null ? other$defaultVal != null : !this$defaultVal.equals(other$defaultVal)) {
            return false;
        }
        List<ExportField> this$children = this.getChildren();
        List<ExportField> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExportField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $prop = this.getProp();
        result = result * 59 + ($prop == null ? 43 : $prop.hashCode());
        result = result * 59 + this.getWidth();
        Object $defaultVal = this.getDefaultVal();
        result = result * 59 + ($defaultVal == null ? 43 : $defaultVal.hashCode());
        List<ExportField> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "ExportField(name=" + this.getName() + ", format=" + this.getFormat() + ", prop=" + this.getProp() + ", width=" + this.getWidth() + ", defaultVal=" + this.getDefaultVal() + ", children=" + this.getChildren() + ")";
    }
}

