/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.excel;

import com.baijia.tianxiao.beanCopy.BeanInvokeUtils;
import com.baijia.tianxiao.beanCopy.BeanMethodInvoke;
import com.baijia.tianxiao.beanCopy.Invoker;
import com.baijia.tianxiao.excel.ExcelCell;
import com.baijia.tianxiao.excel.ExcelCellStyle;
import com.baijia.tianxiao.excel.ExcelColumn;
import com.baijia.tianxiao.excel.ExcelExporterDto;
import com.baijia.tianxiao.excel.ExcelHandler;
import com.baijia.tianxiao.excel.ExcelType;
import com.baijia.tianxiao.excel.Excelable;
import com.baijia.tianxiao.excel.InitAble;
import com.baijia.tianxiao.excel.MapperAble;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractExpoter<T>
implements Excelable<T>,
MapperAble<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(AbstractExpoter.class);
    private String headStrs;
    private String fieldStrs;
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private ExcelCell[] FIELDS_NAME;
    private ExcelHandler excleHandler;
    private Map<String, Invoker<Object>> fieldReaderCache = Maps.newHashMap();
    private static ConcurrentMap<Object, AbstractExpoter<?>> abstractExpoters = Maps.newConcurrentMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> AbstractExpoter<T> putIfAbs(Class<T> clazz) {
        AbstractExpoter<T> ae = null;
        if (!abstractExpoters.containsKey(clazz)) {
            log.info("can not find AbstractExpoter with clazz:{} ", (Object)clazz.getName());
            String string = String.valueOf(clazz.getName());
            synchronized (string) {
                if (!abstractExpoters.containsKey(clazz)) {
                    ae = new AbstractExpoter<T>(clazz);
                    log.info("AbstractExpoter with clazz:{} is:{} ", (Object)clazz.getName(), ae);
                    abstractExpoters.put(clazz, ae);
                }
            }
        } else {
            ae = (AbstractExpoter<T>)abstractExpoters.get(clazz);
        }
        return ae;
    }

    public AbstractExpoter() {
    }

    public AbstractExpoter(String headStrWithSeparatorComma, String fieldStrsWithSeparatorComma, ExcelHandler excelHandler) {
        this.init(headStrWithSeparatorComma, fieldStrsWithSeparatorComma, excelHandler);
    }

    private void init(String headStrWithSeparatorComma, String fieldStrsWithSeparatorComma, ExcelHandler excelCellHandler) {
        this.headStrs = headStrWithSeparatorComma;
        this.fieldStrs = fieldStrsWithSeparatorComma;
        if (GenericsUtils.isNullOrEmpty(this.headStrs) || GenericsUtils.isNullOrEmpty(this.fieldStrs)) {
            throw new IllegalArgumentException("heads's length  is not match with fields's length");
        }
        String[] headNames = this.headStrs.split(",");
        String[] fieldNames = this.fieldStrs.split(",");
        if (GenericsUtils.notNullAndEmpty(fieldNames) && GenericsUtils.notNullAndEmpty(headNames)) {
            if (headNames.length != fieldNames.length) {
                throw new IllegalArgumentException("The length does not match between cellHeads and field");
            }
        } else {
            throw new IllegalArgumentException("can not fill a ExcelCell with those arguments");
        }
        this.FIELDS_NAME = new ExcelCell[headNames.length];
        for (int i = 0; i < this.FIELDS_NAME.length; ++i) {
            String head = headNames[i];
            ExcelCellStyle style = new ExcelCellStyle();
            style.setBoldWeight((short)5120);
            this.FIELDS_NAME[i] = new ExcelCell(head, ExcelCellStyle.HEAD_STYLE);
        }
        this.excleHandler = excelCellHandler;
    }

    public AbstractExpoter(String headStrs, final String fieldStrs) {
        this(headStrs, fieldStrs, new ExcelHandler(){
            {
                String[] fields = fieldStrs.split(",");
                this.batchRegisterHandler(fields, ExcelType.GENERAL);
            }
        });
    }

    public AbstractExpoter(Class<T> clazz) {
        ExcelExporterDto excelExporterAnnt = clazz.getAnnotation(ExcelExporterDto.class);
        if (excelExporterAnnt == null) {
            throw new IllegalArgumentException(String.format("Cannot resolve this class:%s cause by not mark with annotation:%s  ", clazz, ExcelExporterDto.class.getName()));
        }
        this.excleHandler = new ExcelHandler();
        this.resolve(clazz);
    }

    private void resolve(Class<T> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        StringBuilder headsStr = new StringBuilder();
        StringBuilder fieldsStr = new StringBuilder();
        BeanMethodInvoke<T> findBeanMethodInovker = BeanInvokeUtils.findBeanMethodInovker(clazz);
        for (Field field : fields) {
            ExcelColumn annt = field.getAnnotation(ExcelColumn.class);
            if (annt == null) continue;
            String fieldName = field.getName();
            try {
                Invoker<T> fieldReader = findBeanMethodInovker.getFieldReader(fieldName);
                this.fieldReaderCache.put(fieldName, fieldReader);
            }
            catch (Exception e) {
                log.info("can not find fieldReader for clazz:{} with fieldName :{} ", clazz, (Object)fieldName);
                continue;
            }
            String headName = annt.value();
            ExcelType excelType = annt.excelType();
            if (excelType == null) {
                excelType = ExcelType.GENERAL;
            } else if (excelType == ExcelType.DATE) {
                this.excleHandler.registerTimeFormat(fieldName, annt.dataFormat());
            }
            this.excleHandler.registerHandler(fieldName, excelType);
            headsStr.append(headName).append(",");
            fieldsStr.append(fieldName).append(",");
        }
        String headTemp = GenericsUtils.deleteLastCharToString(headsStr);
        String fieldTemp = GenericsUtils.deleteLastCharToString(fieldsStr);
        this.init(headTemp, fieldTemp, this.excleHandler);
    }

    @Override
    public ExcelCell[] exportRowName() {
        return this.FIELDS_NAME;
    }

    @Override
    public ExcelCell[] exportRowValue(T row) {
        ExcelCell[] values = new ExcelCell[this.FIELDS_NAME.length];
        String fieldNamesBySort = this.fieldStrs;
        String[] fieldNames = fieldNamesBySort.split(",");
        if (row instanceof InitAble) {
            ((InitAble)row).initProperties();
        }
        Map<String, Object> fieldValueMapper = this.createValueMap(row, fieldNames);
        this.paramMap.putAll(fieldValueMapper);
        this.setValues(values, fieldValueMapper, fieldNames);
        return values;
    }

    private Map<String, Object> createValueMap(T row, String[] fieldNames) {
        if (GenericsUtils.isNullOrEmpty(fieldNames)) {
            return BeanInvokeUtils.copyToMap(row, fieldNames);
        }
        HashMap retValueMap = Maps.newHashMapWithExpectedSize((int)fieldNames.length);
        for (String fieldName : fieldNames) {
            Invoker<Object> invoker = this.fieldReaderCache.get(fieldName);
            if (invoker == null) continue;
            try {
                retValueMap.put(fieldName, invoker.invoke(row, new Object[0]));
            }
            catch (Exception e) {
                log.info("can not read field's {} value cause by :{} ", (Object)fieldName, (Object)e);
            }
        }
        return retValueMap;
    }

    private void setValues(ExcelCell[] values, Map<String, Object> fieldValueMapper, String ... fieldNames) {
        int i = 0;
        if (GenericsUtils.notNullAndEmpty(fieldNames)) {
            for (String fieldName : fieldNames) {
                Object value = fieldValueMapper.get(fieldName);
                log.debug("fieldName :{} and value is :{} ", (Object)fieldName, value);
                values[i] = this.excleHandler.getExcelValue(fieldName, value);
                ++i;
            }
        }
    }

    public ExcelHandler getHandler() {
        return this.excleHandler;
    }

    @Override
    public void put(String key, Object value) {
        this.paramMap.put(key, value);
    }

    public void initOthers() {
    }

    public String getHeadStrs() {
        return this.headStrs;
    }

    public String getFieldStrs() {
        return this.fieldStrs;
    }

    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public ExcelCell[] getFIELDS_NAME() {
        return this.FIELDS_NAME;
    }

    public ExcelHandler getExcleHandler() {
        return this.excleHandler;
    }

    public Map<String, Invoker<Object>> getFieldReaderCache() {
        return this.fieldReaderCache;
    }

    public void setHeadStrs(String headStrs) {
        this.headStrs = headStrs;
    }

    public void setFieldStrs(String fieldStrs) {
        this.fieldStrs = fieldStrs;
    }

    public void setParamMap(Map<String, Object> paramMap) {
        this.paramMap = paramMap;
    }

    public void setFIELDS_NAME(ExcelCell[] FIELDS_NAME) {
        this.FIELDS_NAME = FIELDS_NAME;
    }

    public void setExcleHandler(ExcelHandler excleHandler) {
        this.excleHandler = excleHandler;
    }

    public void setFieldReaderCache(Map<String, Invoker<Object>> fieldReaderCache) {
        this.fieldReaderCache = fieldReaderCache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractExpoter)) {
            return false;
        }
        AbstractExpoter other = (AbstractExpoter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$headStrs = this.getHeadStrs();
        String other$headStrs = other.getHeadStrs();
        if (this$headStrs == null ? other$headStrs != null : !this$headStrs.equals(other$headStrs)) {
            return false;
        }
        String this$fieldStrs = this.getFieldStrs();
        String other$fieldStrs = other.getFieldStrs();
        if (this$fieldStrs == null ? other$fieldStrs != null : !this$fieldStrs.equals(other$fieldStrs)) {
            return false;
        }
        Map<String, Object> this$paramMap = this.getParamMap();
        Map<String, Object> other$paramMap = other.getParamMap();
        if (this$paramMap == null ? other$paramMap != null : !((Object)this$paramMap).equals(other$paramMap)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFIELDS_NAME(), other.getFIELDS_NAME())) {
            return false;
        }
        ExcelHandler this$excleHandler = this.getExcleHandler();
        ExcelHandler other$excleHandler = other.getExcleHandler();
        if (this$excleHandler == null ? other$excleHandler != null : !this$excleHandler.equals(other$excleHandler)) {
            return false;
        }
        Map<String, Invoker<Object>> this$fieldReaderCache = this.getFieldReaderCache();
        Map<String, Invoker<Object>> other$fieldReaderCache = other.getFieldReaderCache();
        return !(this$fieldReaderCache == null ? other$fieldReaderCache != null : !((Object)this$fieldReaderCache).equals(other$fieldReaderCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractExpoter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $headStrs = this.getHeadStrs();
        result = result * 59 + ($headStrs == null ? 43 : $headStrs.hashCode());
        String $fieldStrs = this.getFieldStrs();
        result = result * 59 + ($fieldStrs == null ? 43 : $fieldStrs.hashCode());
        Map<String, Object> $paramMap = this.getParamMap();
        result = result * 59 + ($paramMap == null ? 43 : ((Object)$paramMap).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getFIELDS_NAME());
        ExcelHandler $excleHandler = this.getExcleHandler();
        result = result * 59 + ($excleHandler == null ? 43 : $excleHandler.hashCode());
        Map<String, Invoker<Object>> $fieldReaderCache = this.getFieldReaderCache();
        result = result * 59 + ($fieldReaderCache == null ? 43 : ((Object)$fieldReaderCache).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractExpoter(headStrs=" + this.getHeadStrs() + ", fieldStrs=" + this.getFieldStrs() + ", paramMap=" + this.getParamMap() + ", FIELDS_NAME=" + Arrays.deepToString(this.getFIELDS_NAME()) + ", excleHandler=" + this.getExcleHandler() + ", fieldReaderCache=" + this.getFieldReaderCache() + ")";
    }
}

