/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.beanCopy;

import com.baijia.tianxiao.beanCopy.BeanMethodInvoke;
import com.baijia.tianxiao.beanCopy.FieldFilter;
import com.baijia.tianxiao.beanCopy.Invoker;
import com.baijia.tianxiao.beanCopy.MethodFilter;
import com.baijia.tianxiao.beanCopy.Typeconverter;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInvokeUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanInvokeUtils.class);
    private static LoadingCache<KeyWrapper<?>, BeanMethodInvoke<?>> beanInvokerCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.DAYS).build(new CacheLoader<KeyWrapper<?>, BeanMethodInvoke<?>>(){

        public BeanMethodInvoke<?> load(KeyWrapper<?> keyWrapper) throws Exception {
            return new BeanMethodInvoke(keyWrapper.getHostClass(), keyWrapper.getFieldFilter(), keyWrapper.getMethodField());
        }
    });

    public static <T> BeanMethodInvoke<T> findBeanMethodInovker(Class<T> hostClass) {
        try {
            return (BeanMethodInvoke)beanInvokerCache.get(new KeyWrapper<T>(hostClass));
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static <T> BeanMethodInvoke<T> findBeanMethodInovker(Class<T> hostClass, FieldFilter fieldFilter, MethodFilter methodFilter) {
        try {
            return (BeanMethodInvoke)beanInvokerCache.get(new KeyWrapper<T>(hostClass, fieldFilter, methodFilter));
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static void copyBean(Object src, Object dest) {
        BeanInvokeUtils.copyBean(src, dest, new Typeconverter(){

            @Override
            public Object convert(String fieldName, Type sourceFieldType, Type destFieldType, Object value) {
                return value;
            }
        });
    }

    public static Map<String, Object> copyToMap(Object src, String[] fieldNames) {
        BeanMethodInvoke<?> srcMethodInvoker = BeanInvokeUtils.findBeanMethodInovker(src.getClass());
        fieldNames = GenericsUtils.isNullOrEmpty(fieldNames) ? srcMethodInvoker.fieldNames.toArray(new String[srcMethodInvoker.fieldNames.size()]) : fieldNames;
        HashMap retValueMap = Maps.newHashMap();
        for (String fieldName : fieldNames) {
            try {
                retValueMap.put(fieldName, srcMethodInvoker.getFieldReader(fieldName).invoke(src, new Object[0]));
            }
            catch (Exception e) {
                log.info("can not read field's() value cause by :{} ", (Object)fieldName, (Object)e);
            }
        }
        return retValueMap;
    }

    public static void copyBean(Object src, Object dest, Typeconverter typeConverter) {
        if (src == null || dest == null) {
            return;
        }
        Class<?> srcHostClass = src.getClass();
        Class<?> destHostClass = dest.getClass();
        BeanMethodInvoke<?> srcMethodInvoker = BeanInvokeUtils.findBeanMethodInovker(srcHostClass);
        BeanMethodInvoke<?> destMethodInovker = BeanInvokeUtils.findBeanMethodInovker(destHostClass);
        for (String fieldName : srcMethodInvoker.getFieldNames()) {
            log.debug("fieldName is :{} ", (Object)fieldName);
            Invoker<?> srcReader = srcMethodInvoker.getFieldReader(fieldName);
            Invoker<?> fieldWriter = destMethodInovker.getFieldWriter(fieldName);
            if (fieldWriter == null) continue;
            Object setValue = srcReader.invoke(src, new Object[0]);
            if (typeConverter != null) {
                setValue = typeConverter.superConvert(fieldName, srcMethodInvoker.getFieldType(fieldName), destMethodInovker.getFieldType(fieldName), setValue);
            }
            log.debug("set value is :{} ", setValue);
            fieldWriter.invoke(dest, setValue);
        }
    }

    static class KeyWrapper<T> {
        Class<T> hostClass;
        FieldFilter fieldFilter;
        MethodFilter methodField;

        public KeyWrapper(Class<T> hostClass) {
            this.hostClass = hostClass;
        }

        public KeyWrapper(Class<T> hostClass, FieldFilter fieldFilter, MethodFilter methodFilter) {
            this.hostClass = hostClass;
            this.fieldFilter = fieldFilter;
            this.methodField = methodFilter;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.hostClass == null ? 0 : this.hostClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyWrapper other = (KeyWrapper)obj;
            return !(this.hostClass == null ? other.hostClass != null : !this.hostClass.equals(other.hostClass));
        }

        public Class<T> getHostClass() {
            return this.hostClass;
        }

        public FieldFilter getFieldFilter() {
            return this.fieldFilter;
        }

        public MethodFilter getMethodField() {
            return this.methodField;
        }

        public void setHostClass(Class<T> hostClass) {
            this.hostClass = hostClass;
        }

        public void setFieldFilter(FieldFilter fieldFilter) {
            this.fieldFilter = fieldFilter;
        }

        public void setMethodField(MethodFilter methodField) {
            this.methodField = methodField;
        }

        public String toString() {
            return "BeanInvokeUtils.KeyWrapper(hostClass=" + this.getHostClass() + ", fieldFilter=" + this.getFieldFilter() + ", methodField=" + this.getMethodField() + ")";
        }
    }
}

