/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.query;

import com.baijia.tianxiao.util.collection.SplitMergeUtils;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.Creator;
import com.baijia.tianxiao.util.query.Merge;
import java.util.Collection;

public abstract class BatchQueryTemplate<Q, R> {
    private int size = 500;

    public R batchQuery(Collection<Q> querySet, BatchQueryCallback<Q, R> callback) {
        return this.batchQuery(querySet, callback, this.getDefCreator(), this.getDefMerge());
    }

    public R batchQuery(Collection<Q> querySet, BatchQueryCallback<Q, R> callback, Creator<R> creator, Merge<R> merge) {
        if (querySet == null || querySet.isEmpty()) {
            return creator.create();
        }
        Collection<Collection<Q>> splitSet = SplitMergeUtils.splitCollection(querySet, this.size);
        R result = creator.create();
        for (Collection<Q> split : splitSet) {
            merge.merge(callback.doQuery(split), result);
        }
        return result;
    }

    public void setSize(int size) {
        this.size = size;
    }

    protected abstract Creator<R> getDefCreator();

    protected abstract Merge<R> getDefMerge();
}

