/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.tianxiao.constants.SmsGateGroup;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.util.http.GSXService;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsSendUtil {
    private static final Logger log = LoggerFactory.getLogger(SmsSendUtil.class);
    public static final String ORG_BANK_UNBIND_CARD = "\u5c0a\u656c\u7684{shortName},\u60a8\u5df2\u6210\u529f\u4ece\u8ddf\u8c01\u5b66\u8d26\u6237\u89e3\u7ed1\u5c3e\u53f7\u4e3a{cardNo}\u7684\u94f6\u884c\u5361\uff0c\u8bf7\u77e5\u6089\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u53ca\u65f6\u62e8\u62534000-910-910";
    public static final String ORG_BANK_BIND_CARD = "\u5c0a\u656c\u7684{shortName}\u673a\u6784,\u60a8\u7684\u8ddf\u8c01\u5b66\u8d26\u6237\u6210\u529f\u7ed1\u5b9a\u4e86\u5c3e\u53f7\u4e3a{cardNo}\u7684\u94f6\u884c\u5361\uff0c\u8bf7\u77e5\u6089\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u53ca\u65f6\u62e8\u62534000-910-910";

    public static boolean sendSms(String mobile, String content, Integer messageType, Integer userId, Integer userRole, boolean directSend, Integer smsGate) {
        if (smsGate != null && smsGate == -1) {
            return false;
        }
        RestfulResult<Object> response = SmsSendUtil.send(mobile, content, messageType, userId, userRole, directSend, smsGate);
        return response.getCode() == 0;
    }

    public static RestfulResult<Object> send(String mobile, String content, Integer messageType, Integer userId, Integer userRole, boolean directSend, Integer smsGate) {
        RestfulResult<Object> response = null;
        try {
            String controller = "sms";
            String action = "send";
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("mobile", mobile.replaceAll(" ", "").replace("-", ""));
            Preconditions.checkArgument((boolean)ParamValidateUtils.validateMobile((String)params.get("mobile")), (Object)("mobile :" + mobile + " is invalidate."));
            params.put("content", content);
            params.put("message_type", String.valueOf(messageType));
            if (userId != null) {
                params.put("user_id", String.valueOf(userId));
            }
            if (userRole != null) {
                params.put("role", String.valueOf(userRole));
            }
            if (directSend) {
                params.put("direct_send", "1");
            }
            if (smsGate != null) {
                params.put("gateway", smsGate.toString());
            } else {
                params.put("gateway", SmsGateGroup.DEFAULT_SMS_GATE.toString());
            }
            log.info("send sms to mobile:{},params:{}", (Object)mobile, params);
            response = GSXService.doService(controller, action, params);
            log.info("params:{}, response:{}", params, response);
        }
        catch (Exception e) {
            response = new RestfulResult<Object>();
            response.setCode(1);
            response.setData(null);
            response.setMsg("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25");
            log.error("sendSms exception - ", (Throwable)e);
        }
        return response;
    }

    public static boolean sendSms(String mobile, String content, Integer messageType, Integer userId, Integer userRole, Integer smsGate) {
        if (smsGate != null && smsGate == -1) {
            return false;
        }
        return SmsSendUtil.sendSms(mobile, content, messageType, userId, userRole, true, smsGate);
    }

    public static void main(String[] args) {
        Integer userId = 489661;
    }
}

